<?php
###############################################################################
# SAML.php
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
#
############################################################################### 

namespace 	CodePunch\Config\SAML;

use 		CodePunch\Base\Util as UTIL;
use			CodePunch\Base\Text as TEXT;
use			CodePunch\DB\Audit as AUDIT;
use 		Exception;

###############################################################################

class SAML Extends SAMLBase {
	
	private $samlauth = null;
	private $authentication = null;
	
	###########################################################################
	
	public function __construct($auth, $doload=true)
	{ 
		parent::__construct($auth);
		if($doload)
			$this->load();
	}
	
	###########################################################################
	
	private function load()
	{
		if($this->samlauth == null) {
			$sed_base_folder = UTIL::get_install_folder_path();
			require_once  "{$sed_base_folder}thirdparty/php-saml/extlib/xmlseclibs/xmlseclibs.php";
			$libDir = "{$sed_base_folder}thirdparty/php-saml/lib/Saml2/";
			$folderInfo = scandir($libDir);
			foreach ($folderInfo as $element) {
				if (is_file($libDir.$element) && (substr($element, -4) === '.php')) {
					include_once $libDir.$element;
				}
			}
			if(UTIL::is_request_key_set(\CodePunch\Config\Auth::DESTINATION))
				$_SESSION[\CodePunch\Config\Auth::DESTINATION] = UTIL::get_sanitized_request_string(\CodePunch\Config\Auth::DESTINATION);
			$this->samlauth = new \OneLogin_Saml2_Auth($this->getSettings());
		}
		return $this->getSAMLAuth();
	}
	
	###########################################################################
	
	public function getSAMLAuth()
	{
		if($this->samlauth == null && $this->authentication != null)
			$this->load();
		return $this->samlauth;
	}
	
	###########################################################################
	
	public function login()
	{
		if($this->getSAMLAuth()) {
			$this->getSAMLAuth()->login();
		}
		# If AuthNRequest ID need to be saved in order to later validate it, do instead
		# $ssoBuiltUrl = $this->getSAMLAuth()->login(null, array(), false, false, true);
		# $_SESSION['AuthNRequestID'] = $this->getSAMLAuth()->getLastRequestID();
		# header('Pragma: no-cache');
		# header('Cache-Control: no-cache, must-revalidate');
		# header('Location: ' . $ssoBuiltUrl);
		# exit();
	}
	
	###########################################################################
	# Attribute Consumer Service
	
	public function ACS()
	{
	}
	
	###########################################################################
	# Single Logout Service
	
	public function SLS()
	{
	}
	
	###########################################################################
	
	public function process()
	{
	}
	
	###########################################################################
	
	public function getSettings()
	{
		$settingsInfo = array('sp'=>array(), 'idp'=>array());
		return $settingsInfo;
	}
}
