<?php
###############################################################################
# Defaults.php
#
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
#
############################################################################### 

namespace 	CodePunch\Config;

use 		CodePunch\Base\Util as UTIL;
use			CodePunch\Base\Text as TEXT;
use 		Exception;

###############################################################################

class Defaults {
	
	const	MAJOR_VERSION =			500;
	const	MINOR_VERSION =			000;
	const	BUILD_DATE =			"2025-01-30";
	const	BUILD_INDEX	=			5079;
	
	const	LANGUAGE = 				"en";
	const	EMAIL_SEND_METHOD = 	"default";
	
	###############################################################################

	private static $the_defaults = array(
		// SETBYDS
		'license_key_code_v5'	=>	'namaqbbCRxIBHA7xQ1K/oaZqT8nZMmr047NH9ML5Tqh1RkXUwNDGLZv+GId3pK2vVWrOhHGFNaIAYFgHqlzlASGlLBLx/7gmgtnFoXtCIMC0dLLzxBcDwcrdd0fGSUUP99fkGBLirDESf3dGuSbnSBxD9ujw=='
	);
	
	###########################################################################
	
	public static function get($key)
	{
		return isset(self::$the_defaults[$key]) ? self::$the_defaults[$key] : false;
	}
	
	###############################################################################
	
	public static function product()
	{
		return "Watch My Domains Server Edition";
	}
	
	###############################################################################
	
	public static function companyname()
	{
		return "Softnik Technologies";
	}
	
	###############################################################################
	
	public static function builddate()
	{
		$btime = strtotime(self::BUILD_DATE);
		return date("M d Y", $btime);
	}
	
	###############################################################################
	
	public static function version()
	{
		$m1 = self::MAJOR_VERSION;
		$m2 = self::MINOR_VERSION;
		return $m1/100 . "." . $m2/100;
	}
	
	###############################################################################
	
	public static function majorversion()
	{
		$m1 = self::MAJOR_VERSION;
		return $m1/100;
	}

	###############################################################################

	public static function version_and_build()
	{
		$version = self::version() . "." . self::BUILD_INDEX;
		return $version . ", " . self::builddate();
	}
}

###############################################################################

