<?php
###############################################################################
# metadata.php
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
#
############################################################################### 

require 'lib/php/loader.php';
session_start();

###############################################################################

use 	CodePunch\Base\Util as UTIL;
use		CodePunch\Base\Text as TEXT;
use 	CodePunch\Config\Auth as AUTH;
error_reporting(E_ALL ^ (E_NOTICE | E_WARNING | E_DEPRECATED));

###############################################################################

try {
	$auth = new \CodePunch\Config\Auth();
	$setup = new \CodePunch\Config\Settings($auth);
	$samlidp = $setup->getOption("saml_idp", "");
	if($samlidp != "") {
		$class = "\\CodePunch\\Config\\SAML\\" . $samlidp;
		if(class_exists($class)) {
			$saml = new $class($auth);
			$samlSettings  = $saml->getSAMLAuth()->getSettings();
			$sp = $samlSettings->getSPData();
			$samlMetadata = OneLogin_Saml2_Metadata::builder($sp);
			header('Content-type: text/xml');
			echo $samlMetadata;
			exit;
		}
	}
	throw new Exception(TEXT::get("saml_invalidsetup"));
}
catch(Exception $e) {
	$logger = new \CodePunch\Base\CPLogger();
	$logger->error($e->getMessage());
	echo $e->getMessage();
	exit;
}

###############################################################################
