<?php
###############################################################################
# API.php
#
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
#
###############################################################################

authenticate_token();

###############################################################################

require 'lib/php/loader.php';

###############################################################################

\CodePunch\UI\API::api();

###############################################################################

function token_decode($input, $dcp) {
	$first_key = base64_decode('PbD6mEcik3Jq7Ed3wDukwAe+6FoYPqGfbvQa8LouISI=');
	$second_key = base64_decode($dcp);        
	$mix = base64_decode($input);

	$method = "aes-256-cbc";    
	$iv_length = openssl_cipher_iv_length($method);
				
	$iv = substr($mix,0,$iv_length);
	$second_encrypted = substr($mix,$iv_length,64);
	$first_encrypted = substr($mix,$iv_length+64);
				
	$data = openssl_decrypt($first_encrypted,$method,$first_key,OPENSSL_RAW_DATA,$iv);
	$second_encrypted_new = hash_hmac('sha3-512', $first_encrypted, $second_key, TRUE);
		
	if($second_encrypted_new !== false && $second_encrypted !== false) {
		if (hash_equals($second_encrypted,$second_encrypted_new))
			return $data;
	}
	return false;
}

###############################################################################

function getBearerToken() {
    $headers = null;
	$requestHeaders = apache_request_headers();
	$requestHeaders = array_combine(array_map('ucwords', array_keys($requestHeaders)), array_values($requestHeaders));
	if (isset($requestHeaders['Authorization'])) {
		$headers = trim($requestHeaders['Authorization']);
	}
    if (!empty($headers)) {
        if (preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
            return $matches[1];
        }
    }
    return null;
}

###############################################################################

function authenticate_token() {
	$etoken = getBearerToken();
	if($etoken != null) {
		include("config.php");
		$token = token_decode($etoken, $db_config_publickey);
		if($token !== false) {
			$parts = explode(';', $token);
			if(count($parts) == 4) {
				$token = $parts[1];
				if(preg_match('/^[-,a-zA-Z0-9]{1,128}$/', $token) > 0) {
					//echo $token . "<br>";
					session_id($token);
					$time = $parts[2];
					if((time() - $time) > 1) {
						session_start();
						session_destroy();
					}
				}
			}
		}
	}
}

###############################################################################
