<?php
###############################################################################
# Duo.php
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
#
############################################################################### 

namespace 	CodePunch\Config\Security;

use 		CodePunch\Base\Util as UTIL;
use			CodePunch\Base\Text as TEXT;
use			CodePunch\DB\Audit  as AUDIT;
use 		Exception;

###############################################################################

include_once(UTIL::get_install_folder_path()."thirdparty/2fa/duo/Web.php");

###############################################################################

class Duo extends Base {
	
	public function getKeys()
	{
		return array(
			'Application Key' => 'Create this yourself (minimum 40 characters long) and keep it a secret. A random key will be generated if this is left empty.', 
			'Integration Key' => 'Obtained from Duo', 
			'Secret Key' => 'Obtained from Duo', 
			'Host Name' => 'Obtained from Duo'
		);
	}
	
	###########################################################################
	
	public function allowDeviceCookie() {
		return false;
	}
	
	###########################################################################
	
	public function get() 
	{
		$auth = $this->getAuthentication();
		$message = "";
				
		$username = UTIL::get_from_array($_SESSION[\CodePunch\Config\Auth::USERNAME], "");
		if($username != "" && $auth && $auth->getDatabase()) {
			$db = $auth->getDatabase();
			$setup = new \CodePunch\Config\Settings($auth);
			
			$twofa_cookie_set_days = $setup->getString("twofa_cookie_set_days", 0);
				if($twofa_cookie_set_days <= 0 || $twofa_cookie_set_days > 45)
					$twofa_cookie_set_days = 0;
			$duo_application_key = $setup->getEncryptedOption("duo_key_application_key", "");
			$duo_integration_key = $setup->getEncryptedOption("duo_key_integration_key", "");
			$duo_secret_key = $setup->getEncryptedOption("duo_key_secret_key", "");
			$duo_hostname = $setup->getEncryptedOption("duo_key_host_name", "");
			if($duo_application_key == "" || strlen($duo_application_key) < 40) {
				$duo_application_key = UTIL::random_string(40);
				$setup->setEncryptedOption("duo_key_application_key", $duo_application_key);
			}
			
			if (isset($_POST['sig_response'])) {
				$sigresponce = $_POST['sig_response'];
				$resp = \Duo\Web::verifyResponse($duo_integration_key, $duo_secret_key, $duo_application_key, $sigresponce);
				if($resp === $username) {
					$auth->processSecondaryLogin($username, $twofa_cookie_set_days);
				}
				else {
				}
			}

			$file = UTIL::get_install_folder_path() . "lib/php/CodePunch/Config/Security/duo/duo.htm";
			$contents = file_get_contents($file);
			$duo_css = "thirdparty/2fa/duo/Duo-Frame.css";
			$extracss = "<link rel=\"stylesheet\" type=\"text/css\" href=\"{$duo_css}\">";
			$duo_jscript = "thirdparty/2fa/duo/Duo-Web-v2.min.js";
			$extrajs = "<script type=\"text/javascript\" src=\"{$duo_jscript}\"></script>";
			$sig_request = \Duo\Web::signRequest($duo_integration_key, $duo_secret_key, $duo_application_key, $username);
			$contents = str_ireplace("{{DUOHOSTNAME}}", $duo_hostname, $contents);	
			$contents = str_ireplace("{{DUOSIGREQUEST}}", $sig_request, $contents);
			$contents = str_ireplace("{{DUOJSCRIPT}}", $duo_jscript, $contents);
			if($twofa_cookie_set_days) {
				$twofavalidate = "<p class=\"small\"><label><input type=\"checkbox\" name='validate_device' id=\"validate_device\">\nDon't ask again on this device for $twofa_cookie_set_days days.</p>";
				$contents = str_ireplace("{{2FAVALIDATE}}", $twofavalidate, $contents);
			}
			$contents = str_ireplace("{{2FAVALIDATE}}", "", $contents);
			
			// Valid keys are home, content, bodytail, headtail, header, footer
			return array('content'=>$contents, 'template'=>'login', 'body'=>$message, 'extrajs'=>$extrajs, 'extracss'=>$extracss);
		}
		return array();
	}
	
}

###############################################################################
