<?php
###############################################################################
# Google.php
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
#
############################################################################### 

namespace 	CodePunch\Config\Security;

use 		CodePunch\Base\Util as UTIL;
use			CodePunch\Base\Text as TEXT;
use 		Exception;

###############################################################################

class Base {
	
	private $authentication	= null;
	
	###########################################################################
	
	public function __construct($auth = null)
	{ 
		$this->authentication = $auth;
	}
	
	###########################################################################
	
	public function getAuthentication() {
		return $this->authentication;
	}
	
	###########################################################################
	
	public function createUserColumn($fname, $ftype="string", $fwidth=255)
	{
		if($this->authentication && $this->authentication->getDatabase()) {
			$db = $this->authentication->getDatabase();
			$columns = $db->getAllColumnNames($db->getuserTableName());
			if(!in_array($fname, $columns)) {
				$columninfo = array('name'=>$fname, 'type'=>$ftype, 'options'=>array());
				$columninfo['options']['notnull'] = false;
				if($ftype == "string")
					$columninfo['options']['length'] = $fwidth;
				$keys = array();
				$db->insertColumnsAndKeys($db->getuserTableName(),  array($columninfo), $keys);
			}
		}
	}
	
	###########################################################################
	
	public function getKeys()
	{
		return array('');
	}
	
	###########################################################################
	
	public function isEnabled() {
		return true;
	}
	
	###########################################################################
	
	public function allowDeviceCookie() {
		return true;
	}
}
