<?php
###############################################################################
# Defaults.php
#
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
#
############################################################################### 

namespace 	CodePunch\Config;

use 		CodePunch\Base\Util as UTIL;
use			CodePunch\Base\Text as TEXT;
use 		Exception;

###############################################################################

class Defaults {
	
	const	MAJOR_VERSION =			500;
	const	MINOR_VERSION =			000;
	const	BUILD_DATE =			"2025-01-30";
	const	BUILD_INDEX	=			5079;
	
	const	LANGUAGE = 				"en";
	const	EMAIL_SEND_METHOD = 	"default";
	
	###############################################################################

	private static $the_defaults = array(
		// SETBYDS
		'license_key_code_v5'	=>	'namk2a2yH755DB8hRUXR1PijsJAEyO8ZRpo+TYI7sD0V5DA1g921DrOBmVr7LlUy5ycKrDS+XOimNSkgMGIDqHQJy+5R3CAm5O47ruKBIenkzMOkfkFOAUypL0XcE3y8uwEjfnz5d4YaFm8T5EeJrpkiEUpg=='
	);
	
	###########################################################################
	
	public static function get($key)
	{
		return isset(self::$the_defaults[$key]) ? self::$the_defaults[$key] : false;
	}
	
	###############################################################################
	
	public static function product()
	{
		return "Watch My Domains Server Edition";
	}
	
	###############################################################################
	
	public static function companyname()
	{
		return "Softnik Technologies";
	}
	
	###############################################################################
	
	public static function builddate()
	{
		$btime = strtotime(self::BUILD_DATE);
		return date("M d Y", $btime);
	}
	
	###############################################################################
	
	public static function version()
	{
		$m1 = self::MAJOR_VERSION;
		$m2 = self::MINOR_VERSION;
		return $m1/100 . "." . $m2/100;
	}
	
	###############################################################################
	
	public static function majorversion()
	{
		$m1 = self::MAJOR_VERSION;
		return $m1/100;
	}

	###############################################################################

	public static function version_and_build()
	{
		$version = self::version() . "." . self::BUILD_INDEX;
		return $version . ", " . self::builddate();
	}
}

###############################################################################

