class SSLColumns {
	constructor(options={}) {
		if(!SSLColumns._instance) {
			this.init(options);
			SSLColumns._instance = this;
		}
		return SSLColumns._instance;
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////
	
	init(options) {
		this.current_columns = [];
		this.options = options;
		let ui = new UserInput();
		ui.eventHandler('#panel-sslcolumns', this);
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////
	
	show(options={}) {
		var datastr = SEDAPI.construct("get", "sslcerts", "colmodel");
		SEDAPI.call(datastr, this.apiGotSSLColumns.bind(this), null);
		new PopupPanel("panel-sslcolumns");
		this.showStatus('');
	}

	/////////////////////////////////////////////////////////////////////////////////////////
	
	showStatus(msg) {
		PopupPanel.showStatus('sslcolumns-error', msg);
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////
	
	apiGotSSLColumns(x, jqXHR, textStatus, params) {
		if(x != null) {
			if(x.status == 'ok') {
				var html = '';
				var di = 1;
				for(var i = 0; i < x.current.length; i++) {
					var cn = x.current[i];
					if(cn != "r_h_disp") {
						html += "<li tabindex=\"0\" data-index=\"" + di + "\" data-id=\"" + cn + "\">" + cn + "</li>";
						di++;
					}
				}
				for(var i = 0; i < x.columns.length; i++) {
					var cn = x.columns[i];
					if(x.current.includes(cn) === false) {
						if(cn != "r_h_disp") {
							html += "<li tabindex=\"0\" data-index=\"" + di + "\"data-id=\"" + cn + "\">" + cn + "</li>";
							di++;
						}
					}
				}
				$('#sslcolumns-columns').html(html);
				var instance = this;
				var lb = new ItemList('sslcolumns-columns', {
					sortable:true, 
					checkbox: true,
					onsort: function(itemid, ui) {
						instance.rowsSorted(itemid, ui);
					},
					nosort:'nosort'
				});
				lb.setSelectionIds(x.current);
			}
		}
	}
	
	rowsSorted(itemid, ui) {
	}
	
	sslColumnsReset() {
		this.showStatus("Please wait");
		var datastr = SEDAPI.construct("set", "sslcerts", "colmodel");
		datastr += "&columns=";
		SEDAPI.call(datastr, this.apiUpdatedSSLColumns.bind(this), "reset");
	}
	
	sslColumnsSetup() {
		var lb = ItemList.getItemList('sslcolumns-columns');
		var checkedIds = lb.getSelectionIds();
		var colsetup = "";
		var length = checkedIds.length;
		var columns = new Array();
		for (var i = 0; i < length; i++) {
		  columns[i] = checkedIds[i];
		  colsetup += columns[i];
		  if(i != (length-1))
			colsetup += ";";
		}
		this.showStatus("Please wait");
		var datastr = SEDAPI.construct("set", "sslcerts", "colmodel");
		datastr += "&columns=" + encodeURIComponent(colsetup);
		SEDAPI.call(datastr, this.apiUpdatedSSLColumns.bind(this), null);
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////

	apiUpdatedSSLColumns(x, jqXHR, textStatus, params) {
		if(x != null) {
			if(x.status == 'ok') {
				this.showStatus('ok');
				var dt = DataTableView.getTable("ssldatatable");
				dt.setColumns(x.colmodel);
				dt.reload();
				if(params == 'reset')
					PopupPanel.hidePanel("panel-sslcolumns");
			}
			else
				this.showStatus(x.error);
		}
	}
}
