<?php
###############################################################################
# Defaults.php
#
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
#
############################################################################### 

namespace 	CodePunch\Config;

use 		CodePunch\Base\Util as UTIL;
use			CodePunch\Base\Text as TEXT;
use 		Exception;

###############################################################################

class Defaults {
	
	const	MAJOR_VERSION =			600;
	const	MINOR_VERSION =			000;
	const	BUILD_DATE =			"2025-06-23";
	const	BUILD_INDEX	=			6008;
	
	const	LANGUAGE = 				"en";
	const	EMAIL_SEND_METHOD = 	"default";
	
	###############################################################################

	private static $the_defaults = array(
		// SETBYDS
		'license_key_code_v6'	=>	'namk2a9hF6/DHYSMJBB4PC+Rqd02zxAOZVTW4+m5cGU0pqDioYNybUtNxdNUQc4pb57UbgnWyQ7PO1EwXoiyLxkOtJh7KTcbO8powKN+YdyxnaG0ZaJW94y4+2RfbSmGhmkEUGX5BuJ+VAuFpHHJqF5DCcJA=='
	);
	
	###########################################################################
	
	public static function get($key)
	{
		return isset(self::$the_defaults[$key]) ? self::$the_defaults[$key] : false;
	}
	
	###############################################################################
	
	public static function product()
	{
		return "Watch My Domains Server Edition";
	}
	
	###############################################################################
	
	public static function companyname()
	{
		return "Softnik Technologies";
	}
	
	###############################################################################
	
	public static function builddate()
	{
		$btime = strtotime(self::BUILD_DATE);
		return date("M d Y", $btime);
	}
	
	###############################################################################
	
	public static function version()
	{
		$m1 = self::MAJOR_VERSION;
		$m2 = self::MINOR_VERSION;
		return $m1/100 . "." . $m2/100;
	}
	
	###############################################################################
	
	public static function majorversion()
	{
		$m1 = self::MAJOR_VERSION;
		return $m1/100;
	}

	###############################################################################

	public static function version_and_build()
	{
		$version = self::version() . "." . self::BUILD_INDEX;
		return $version . ", " . self::builddate();
	}
}

###############################################################################

