class SSLSchedule {
	constructor(options={}) {
		if(!SSLSchedule._instance) {
			this.init(options);
			SSLSchedule._instance = this;
		}
		return SSLSchedule._instance;
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////
	
	init(options) {
		this.options = options;
		let ui = new UserInput();
		ui.eventHandler('#panel-reportschedule', this);
		
		new SelectBox('reportschedule-email');
		new SelectBox('reportschedule-runits', {change:this.runFrequencyChanged.bind(this)});
		new SelectBox('reportschedule-hour');
		new SelectBox('reportschedule-date');
		new SelectBox('reportschedule-week');
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////
	
	show(options={}) {
		for(var key in options) {
			if(options.hasOwnProperty(key)) {
				this.options[key] = options[key];
			}
		}
		$('#reportschedule-report-name').html("SSL Report");
		var datastr = SEDAPI.construct("get", "sslcerts", "report");
		SEDAPI.call(datastr, this.apiGotSelectedReportData.bind(this), null);
		new PopupPanel("panel-reportschedule");
	}

	/////////////////////////////////////////////////////////////////////////////////////////
	
	showStatus(msg) {
		PopupPanel.showStatus('reportschedule-error', msg);
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////

	getData(oper) {
		var name = "SSL Browser Report";
		var frequency = $('#reportschedule-frequency').val();
		if(frequency == "")
			frequency = "30";
		var combined = this.get_runits();
		var enabled = SelectBox.getSelectBox('reportschedule-email').get();
		var emails = $('#reportschedule-emailto').val();
		var datastr = "";
		if(name != "") {
			datastr = SEDAPI.construct("set", "sslcerts", oper);
			datastr += "&name=" + encodeURIComponent(name);
			datastr += "&frequency=" + encodeURIComponent(frequency);
			datastr += "&runits=" + encodeURIComponent(combined);
			datastr += "&autorun=" + encodeURIComponent(enabled);
			datastr += "&emails=" + encodeURIComponent(emails);
		}
		return datastr;
	}
	
	apiGotSelectedReportData(x, jqXHR, textStatus, params) {
		if(x != null) {
			if(x.status == 'ok') {
				x.runits = parseInt(x.runits)
				var runits = x.runits & 0xF;
				var hour = (x.runits >> 4) & 0xFF;
				var date = (x.runits >> 12) & 0xFF;
				var week = (x.runits >> 20) & 0xF;
				if(runits < 2 || runits > 4)
					runits = 3;
				if(hour < 1 || hour > 24)
					hour = 1;
				if(date < 1 || date > 28)
					date = 1;
				if(week < 1 || week > 7)
					week = 1;
				
				if(x.frequency <= 0)
					x.frequency = 1;
				SelectBox.getSelectBox('reportschedule-runits').set(runits);
				$('#reportschedule-frequency').val(parseInt(x.frequency));
				
				var sb = SelectBox.getSelectBox('reportschedule-email');
				sb.set(x.autorun ? "1" : "0");
				
				$('#reportschedule-emailto').val(x.emails);
				SelectBox.getSelectBox('reportschedule-date').set(date);
				SelectBox.getSelectBox('reportschedule-hour').set(hour);
				SelectBox.getSelectBox('reportschedule-week').set(week);
			}
			this.runFrequencyChanged();
		}
	}

	/////////////////////////////////////////////////////////////////////////////////////////

	get_runits() {
		var runits = SelectBox.getSelectBox('reportschedule-runits').get();
		var date = SelectBox.getSelectBox('reportschedule-date').get();
		var hour = SelectBox.getSelectBox('reportschedule-hour').get();
		var week = SelectBox.getSelectBox('reportschedule-week').get();
		
		var combined = (parseInt(week) << 20) | (parseInt(date) << 12) | (parseInt(hour) << 4) | (parseInt(runits) & 0xF);
		return combined;
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////

	runFrequencyChanged() {
		var runits = parseInt(SelectBox.getSelectBox('reportschedule-runits').get());
		if(runits == 2) { // Daily
			$('#reportschedule-date-group').hide();
			$('#reportschedule-week-group').hide();
		}
		else if(runits == 3) { // Weekly
			$('#reportschedule-week-group').show();
			$('#reportschedule-date-group').hide();
		}
		else if(runits == 4) { // Monthly
			$('#reportschedule-week-group').hide();
			$('#reportschedule-date-group').show();
		}
	}
	
	reportScheduleSetup() {
		var datastr = this.getData('report');
		console.log(datastr);
		SEDAPI.call(datastr, this.apiUpdatedReportSettings.bind(this), this.options.report);
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////

	apiUpdatedReportSettings(x, jqXHR, textStatus, params) {
		if(x != null) {
			console.log(x);
			if(x.status == 'ok') {
				this.showStatus('ok');
				if(this.options && this.options.refresh) 
					this.options.refresh(this.options.report);
			}
			else
				this.showStatus(x.error);
		}
	}
}

	