<div style="padding: 0 10px; margin-top: 20px;">
<?php
	if($viewMode == "normal" && !$isAdmin) {
		echo "<span>The data sets and export options are configured by administrators. Please contact an administrator if changes are needed.</span>";
	}
	else if($viewMode == "normal") {
		echo "<p>Administrators can configure the data set options including the columns to add.</p>";
		echo "<a href=\"" . $baseUrl . "tools/export-domains.php?view=admin\"" . " class=\"btn btn-block btn-primary\">Switch to Admin</a>";
	}
	else {
		echo "<p class=\"label\">Admin Mode</p>";
		echo "<a href=\"" . $baseUrl . "tools/export-domains.php?view=normal\"" . " class=\"btn btn-block btn-primary\">Switch to Normal</a>";
	}
?>   
</div>

   <div class="panel panel-config">
        
        <div class="dataset-load-only">
            <div class="field-row">
                <label for="dataset_select">Saved data sets</label>
                <div class="dataset-row">
                    <select id="dataset_select">
                        <option value="">No data set selected</option>
                    </select>
                </div>

                <div class="dataset-row-buttons">
                    <button type="button" class="btn btn-success btn-sm" id="btn_load_dataset">Load</button>
                    <button type="button" class="btn btn-danger btn-sm data-set-config" id="btn_delete_dataset">Delete</button>
                </div>
            </div>
        </div>

        <!-- Admin-only configuration block (hidden in normal-user mode) -->
        <div class="data-set-config">
            <div class="field-row">
                <label for="dataset_name">Save current selection as</label>
                <input type="text" id="dataset_name" placeholder="Example: Expiry 30 days - basic fields">
                <button type="button" class="btn btn-primary btn-sm btn-block" id="btn_save_dataset">Save data set</button>
            </div>

            <hr class="section-divider">

            <h3>Domain selection</h3>

            <div class="field-row">
                <label for="filter_category">Category</label>
                <select id="filter_category">
                    <option value="">All categories</option>
                </select>
                <div class="help-text">
                    Choose a category to limit the export. Leave as "All categories" to export from the full domain table.
                </div>
            </div>

            <div class="field-row">
                <label for="filter_query">Additional query (optional)</label>
                <input type="text" id="filter_query" placeholder="Example: d.days_to_expiry &lt; 30">
                <div class="help-text">
                    This value is passed directly to the grid query parameter. Use only if you are familiar with
                    the advanced query options in Watch My Domains SED.
                </div>
            </div>

            <hr class="section-divider">

            <h3>Column selection</h3>
            <p class="help-text">
                Select which gridview columns should be exported. You can adjust the header labels for the CSV on the right.
            </p>

            <div id="columns-list" class="columns-list">
                Loading domain columns...
            </div>

            <!-- Computed columns UI -->
            <hr class="section-divider">
            <h3>Computed columns</h3>
            <p class="help-text">
                Add virtual columns based on simple expressions. Currently supported: <code>!field_name</code> to invert a boolean 1/0 field.
            </p>
            <div class="field-row">
                <label for="computed_col_name">New computed column</label>
                <div class="computed-input-row">
                    <input type="text" id="computed_col_name" placeholder="Internal name, e.g. not_auto_renew">
                    <input type="text" id="computed_col_expr" placeholder="Expression, e.g. !auto_renew">
                    <button type="button" class="btn btn-success btn-block btn-sm" id="btn_add_computed">Add</button>
                </div>
            </div>
            <div class="field-row" style="margin-top: 20px;">
                <label>Computed Columns</label>
                <div id="computed-list" class="computed-list">
                    None defined.
                </div>
            </div>

            <hr class="section-divider">
            <h3>Configuration export</h3>
            <p class="help-text">
                When you are satisfied with your data sets and column mappings, click below to save the configuration to the server. The saved configuration will be available to all regular users and to administrators in regular-user mode.
            </p>
            <button type="button" class="btn btn-danger btn-sm btn-block" id="btn_export_config">Save configuration</button>
        </div>
    </div>