<?php

$baseUrl = null;
$apiBaseUrl = null;

///////////////////////////////////////////////////////////////////////////////

getURLs(); 

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$isAdmin         = is_admin();
$currentUserName = isset($_SESSION['sed6name']) ? $_SESSION['sed6name'] : '';

///////////////////////////////////////////////////////////////////////////////
/**
 * View mode:
 *   view=admin  : admin setup mode (if user is admin)
 *   view=normal : regular-user mode (even for admins)
 */
$viewMode = 'normal';
if (isset($_GET['view'])) {
    $tmp = strtolower(trim($_GET['view']));
    if ($tmp === 'normal' || $tmp === 'admin') {
        $viewMode = $tmp;
    }
}
$effectiveIsAdmin = $isAdmin && $viewMode !== 'normal';

///////////////////////////////////////////////////////////////////////////////

$excludedColumns = [
    'domain',
    'sid',
];

///////////////////////////////////////////////////////////////////////////////

$postedDynamic = [];
if (!empty($_POST)) {
    foreach ($_POST as $k => $v) {
        if (strpos($k, 'col_') === 0) {
            $postedDynamic[$k] = $v;
        }
    }
}

///////////////////////////////////////////////////////////////////////////////

function getURLs() {
	global $baseUrl, $apiBaseUrl;
	$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
	$host = $_SERVER['HTTP_HOST'];
	// Current script directory (e.g. /apps/wmdsed/subfolder)
	$currentDir = dirname($_SERVER['SCRIPT_NAME']);
	// Go one folder up
	$parentDir = dirname($currentDir);
	$baseUrl = rtrim($protocol . $host . $parentDir, '/') . '/';
	$apiBaseUrl = $baseUrl . "api.php";
}

///////////////////////////////////////////////////////////////////////////////

function is_admin()
{
    return isset($_SESSION['sed6info']['admin']) && $_SESSION['sed6info']['admin'] == 1;
}

///////////////////////////////////////////////////////////////////////////////
