<?php

///////////////////////////////////////////////////////////////////////////////

define('THIS_TOOL_NAME', 'export-domains');
define('ADD_DOMAINS_CONFIG_KEY', str_replace('-', '_', THIS_TOOL_NAME) . '_tool');

///////////////////////////////////////////////////////////////////////////////

include "includes/base-init.php";
include "includes/head-top.php"
?>

<body>

<div class="theme-select theme-bg" id="themechange"></div>
<div class="menu-select theme-bg" id="menuselect"></div>
<div id="contentwrap">
<?php include "includes/head-logo-toolbar.php" ?>
<?php include "includes/login-required.php" ?>
<div id="content">
	<div id="menucontrol">
<?php include "includes/export-domains-sidebar.php" ?>
	</div>
	<div id="maincontent">
		<div id="domaindata">
			<div class="panel panel-export">
				<h1>Domain Tool Box: Export Data</h1>
				
				<p class="help-text hidden-if-not-admin" style="margin-top:4px; margin-bottom:12px;">
					You can drag and drop rows in the table below to change the order of exported columns.
				</p>

				<div class="field-row">
					<label>Columns included in export</label>
					<div class="help-text">
						You can customize the column headings used in the CSV export. If you leave a heading blank, the default name will be used.
					</div>
					<div id="selected-columns-config" class="selected-columns-config">
						<div style="padding: 10px; background-color: #FFEEEE; line-height: 150%; color: #800000;">No columns have been selected yet. An administrator must configure and save the export options before this feature can be used.
						</div>
					</div>
				</div>
				
				<!-- Boolean format selector -->
				<div class="field-row">
					<label for="bool_format">Yes or No display</label>
					<select id="bool_format">
						<option value="10">1 / 0</option>
						<option value="YN">Y / N</option>
						<option value="YESNO">Yes / No</option>
						<option value="TF">True / False</option>
						<option value="EN">Enabled / Disabled</option>
					</select>
					<div class="help-text">
						Choose the wording used for Yes or No values when exporting your data.
					</div>
				</div>

				<div class="field-row">
					<label for="rows_per_page">Export batch size</label>
					<input type="number" id="rows_per_page" value="500" min="50" max="5000">
					<div class="help-text">
						This controls how much data is processed at a time during export. All rows will be included automatically. If you are unsure, it is best to leave the default value unchanged.
					</div>
				</div>

				<div class="field-row">
					<label>Summary</label>
					<div id="export-summary" class="export-summary">
						No configuration yet.
					</div>
				</div>

				<div class="form-actions">
					<button type="button" class="btn btn-primary" id="btn_preview">Preview first 20 rows</button>
					<button type="button" class="btn btn-success" id="btn_export">Download CSV</button>
				</div>

				<div id="status-area" class="status-area"></div>
				<div id="preview-area" class="preview-area"></div>
			</div>
		</div>
	</div>
</div>
</div>


<?php
///////////////////////////////////////////////////////////////////////////////
$jsApiBaseUrl      = htmlspecialchars($apiBaseUrl, ENT_QUOTES, 'UTF-8');
$jsExcludedColumns = json_encode($excludedColumns);
$jsPostedDynamic   = json_encode($postedDynamic);
///////////////////////////////////////////////////////////////////////////////
?>
<script>
var baseurl           = "<?php echo $baseUrl; ?>";
var API_BASE_URL      = <?php echo json_encode($jsApiBaseUrl); ?>;
var EXCLUDED_COLUMNS  = <?php echo $jsExcludedColumns; ?>;
var POSTED_VALUES     = <?php echo $jsPostedDynamic; ?>;
var IS_ADMIN          = <?php echo $effectiveIsAdmin ? 'true' : 'false'; ?>;
var REAL_ADMIN        = <?php echo $isAdmin ? 'true' : 'false'; ?>;
var VIEW_MODE         = <?php echo json_encode($viewMode); ?>;
var CURRENT_USER      = <?php echo json_encode($currentUserName); ?>;
var ADD_DOMAINS_CONFIG_KEY = "<?php echo ADD_DOMAINS_CONFIG_KEY; ?>";
var CONFIG_CREATED_AT = <?php echo time(); ?>;
var USE_JS_ADD_HANDLER = true;
</script>
<script type="text/javascript" src="tools/js/common.js"></script>
<script type="text/javascript" src="tools/js/domain-export.js"></script>
</body>
</html>
