<?php

///////////////////////////////////////////////////////////////////////////////

define('THIS_TOOL_NAME', 'add-domains');
define('ADD_DOMAINS_CONFIG_KEY', str_replace('-', '_', THIS_TOOL_NAME) . '_tool');

///////////////////////////////////////////////////////////////////////////////

include "includes/base-init.php";
include "includes/head-top.php"
?>

<body>

<div class="theme-select theme-bg" id="themechange"></div>
<div class="menu-select theme-bg" id="menuselect"></div>
<div id="contentwrap">
<?php include "includes/head-logo-toolbar.php" ?>
<?php include "includes/login-required.php" ?>
<div id="content">
	<div id="menucontrol">
<?php include "includes/add-domains-sidebar.php" ?>
	</div>
	<div id="maincontent">
		<div id="domaindata">
			<div class="add-domain-panel">
				<h1>Domain Tool Box: Add Domains</h1>
				
				<!--
				<input id="domain_add_mode" type="checkbox" class="auto-toggle" data-label-left="Single Domain Mode" data-label-right="Multiple Domains as CSV">
				-->
				<div class="field-row">
					<label for="add_mode">Data Entry Mode</label>
					<select id="add_mode">
						<option value="single">Add Single Domain at a Time</option>
						<option value="bulk">Add Multiple Domains in Bulk</option>
					</select>
					
				</div>
				
				<hr>

				<div id="single-add-container" class="add-block">
					
					<form id="add-domain-form" method="post" action="">
						<input type="hidden" name="action" value="add_domain">
						<input type="hidden" name="extra_columns" id="extra_columns" value="">

						<div class="field-row">
							<label for="domain">Domain</label>
							<input type="text" name="domain" id="domain"
								   placeholder="example.com or sub.domain.com"
								   value="">
						</div>
						
						<div id="extra-fields-container">
						</div>

						<div class="field-row">
							<label for="category_id">Category</label>
							<select name="category_id" id="category_id">
								<option value="">No category</option>
							</select>
							<div class="help-text">
								Only one category can be selected. Leave as "No category" to skip categorization.
							</div>
						</div>

						<div class="form-actions">
							<button type="button" class="btn btn-danger" id="clear-form-btn">Clear</button>
							<button type="submit" class="btn btn-primary">Add Domain</button>
						</div>
						<div id="single-domain-add-status" class="submit-status-text"></div>
					</form>
				</div>
				
				<div id="bulk-add-container" class="add-block">
					

					<form id="bulk-add-form" method="post" action="">
						<input type="hidden" name="action" value="add_bulk">
						<input type="hidden" name="bulk_extra_columns" id="bulk_extra_columns" value="">

						<p class="help-text">
							Enter one row per line, with values separated by commas. Do <u>not</u> include column headers, only data rows. Each row must be in Comma Separated Values (CSV) format and list values in the specified order.
						</p>

						<p id="bulk-help-text" class="help-text">
							Loading column order…
						</p>

						<div class="field-row">
<textarea
	name="bulk_csv"
	id="bulk_csv"
	rows="12"
	style="width:100%; box-sizing:border-box;"
	placeholder="example.com, value&#10;example.net, value">
</textarea>
						</div>

						<div class="field-row">
							<label for="bulk_category_id">Category</label>
							<select name="bulk_category_id" id="bulk_category_id">
								<option value="">No category</option>
							</select>
							<div class="help-text">If a category is selected, all the added domains will be added to that category.</div>
						</div>

						<div class="form-actions">
							<button type="submit" class="btn btn-primary">Add Multiple Domains</button>
						</div>
						<div id="bulk-domain-add-status" class="submit-status-text"></div>
					</form>
				</div>

			</div>
		</div>
	</div>
</div>
</div>


<?php
///////////////////////////////////////////////////////////////////////////////
$jsApiBaseUrl      = htmlspecialchars($apiBaseUrl, ENT_QUOTES, 'UTF-8');
$jsExcludedColumns = json_encode($excludedColumns);
$jsPostedDynamic   = json_encode($postedDynamic);
///////////////////////////////////////////////////////////////////////////////
?>
<script>
var baseurl           = "<?php echo $baseUrl; ?>";
var API_BASE_URL      = <?php echo json_encode($jsApiBaseUrl); ?>;
var EXCLUDED_COLUMNS  = <?php echo $jsExcludedColumns; ?>;
var POSTED_VALUES     = <?php echo $jsPostedDynamic; ?>;
var IS_ADMIN          = <?php echo $effectiveIsAdmin ? 'true' : 'false'; ?>;
var REAL_ADMIN        = <?php echo $isAdmin ? 'true' : 'false'; ?>;
var VIEW_MODE         = <?php echo json_encode($viewMode); ?>;
var CURRENT_USER      = <?php echo json_encode($currentUserName); ?>;
var ADD_DOMAINS_CONFIG_KEY = "<?php echo ADD_DOMAINS_CONFIG_KEY; ?>";
var CONFIG_CREATED_AT = <?php echo time(); ?>;
var USE_JS_ADD_HANDLER = true;
</script>
<script type="text/javascript" src="tools/js/common.js"></script>
<script type="text/javascript" src="tools/js/domain-add.js"></script>
</body>
</html>
