<?php
###############################################################################
# Defaults.php
#
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
#
############################################################################### 

namespace 	CodePunch\Config;

use 		CodePunch\Base\Util as UTIL;
use			CodePunch\Base\Text as TEXT;
use 		Exception;

###############################################################################

class Defaults {
	
	const	MAJOR_VERSION =			610;
	const	MINOR_VERSION =			000;
	const	BUILD_DATE =			"2026-01-09";
	const	BUILD_INDEX	=			6101;
	
	const	LANGUAGE = 				"en";
	const	EMAIL_SEND_METHOD = 	"default";
	
	###############################################################################

	private static $the_defaults = array(
		// SETBYDS
		'license_key_code_v6'	=>	'namaqbyGtamugcmZBg7l3lu7aBPeIIuEEg8hwwz+0I0U7s31+Jvvzi8A4ALNbskQ0mZCBhSM+5Br94bT/m2Fsp50bmn7NpXZK4NrS6GlK1pcM//u4P2D7uFNZJVMI+35GWXstyAUAkjBXdhf232y8CS13rdg=='
	);
	
	###########################################################################
	
	public static function get($key)
	{
		return isset(self::$the_defaults[$key]) ? self::$the_defaults[$key] : false;
	}
	
	###############################################################################
	
	public static function product()
	{
		return "Watch My Domains Server Edition";
	}
	
	###############################################################################
	
	public static function companyname()
	{
		return "Softnik Technologies";
	}
	
	###############################################################################
	
	public static function builddate()
	{
		$btime = strtotime(self::BUILD_DATE);
		return date("M d Y", $btime);
	}
	
	###############################################################################
	
	public static function version()
	{
		$m1 = self::MAJOR_VERSION;
		$m2 = self::MINOR_VERSION;
		return $m1/100 . "." . $m2/100;
	}
	
	###############################################################################
	
	public static function majorversion()
	{
		$m1 = self::MAJOR_VERSION;
		return $m1/100;
	}

	###############################################################################

	public static function version_and_build()
	{
		$version = self::version() . "." . self::BUILD_INDEX;
		return $version . ", " . self::builddate();
	}
}

###############################################################################

