
var header_logo_image = '{{header.logo}}';
var header_logo_big_image = '{{header.logobig}}';

var main_logo_image = '{{LOGOIMAGE}}';
var main_logo_big_image = '{{BIGLOGOIMAGE}}';
var main_background_image = '{{BACKGROUNDIMAGE}}';
var main_background_prop = '{{BACKGROUNDPROP}}';
var main_background_size = '{{BACKGROUNDSIZE}}';

var app_root_url = '{{APPROOTURL}}';
var api_url_path = '{{APIURLPATH}}';

window.chartColors = {
	red: 'rgba(245, 158, 11, 1)',
	orange: 'rgba(220, 38, 38, 1)',
	purple: 'rgba(96, 165, 250, 1)',
	green: 'rgba(34, 197, 94, 1)',
	blue: 'rgba(54, 55, 255, 1)',
	skyblue: 'rgba(148, 163, 184, 1)',
	grey: 'rgba(150, 150, 150, 1)'
};

var dashboard_chart_config = {
	type: 'pie',
	data: {
		datasets: [{
			data: [
				{{DBDTCOUNT:registry_expiry < [TODAY+60]}},
				{{DBDTCOUNT:registry_expiry < [TODAY] OR registrar_expiry < [TODAY]}},
				{{DBDTCOUNT:registry_expiry is NULL AND availability != 'Available'}},
				{{DBDTCOUNT:primary_whois_checked_at is NULL OR primary_whois_checked_at < [TODAY-180]}},
				{{DBDTCOUNT:}}
			],
			backgroundColor: [
				window.chartColors.red,
				window.chartColors.orange,
				window.chartColors.purple,
				window.chartColors.skyblue,
				window.chartColors.green
			],
			borderColor: [
			  'rgba(255, 99, 132, 0.2)',
			  'rgba(255, 159, 64, 0.2)',
			  'rgba(255, 205, 86, 0.2)',
			  'rgba(75, 192, 192, 0.2)',
			  'rgba(54, 162, 235, 0.2)'
			],
			borderWidth: 1,
			label: 'Dataset 1'
		}],
		labels: [
			'Expiring soon',
			'Already Expired',
			'Missing Expiry Date',
			'Not Checked',
			'Other'
		]
	},
	options: {
		responsive: true,
		maintainAspectRatio: true,
		legend: {
			position: 'right'
		},
		title: {
			display: true,
			text: ''
		},
		animation: {
			animateScale: false,
			animateRotate: false
		},
		plugins: {
            legend: {
                labels: {
                    font: {
						family: 'Roboto Slab', 
                        size: 14
                    }
                }
            }
        }
	}
};	


var expiry_stats_config = {
	type: 'bar',
	data: {
		datasets: [{
			label: 'Domains Expiring In',
			data: [
				{{DBDTCOUNT:registry_expiry < [TODAY+7]}},
				{{DBDTCOUNT:registry_expiry < [TODAY+14]}},
				{{DBDTCOUNT:registry_expiry < [TODAY+30]}},
				{{DBDTCOUNT:registry_expiry < [TODAY+60]}},
				{{DBDTCOUNT:registry_expiry < [TODAY+90]}}
			],
			backgroundColor: [
				window.chartColors.red,
				window.chartColors.orange,
				window.chartColors.skyblue,
				window.chartColors.purple,
				window.chartColors.green
			],
			borderColor: [
			  'rgb(255, 99, 132)',
			  'rgb(255, 159, 64)',
			  'rgb(255, 205, 86)',
			  'rgb(75, 192, 192)',
			  'rgb(54, 162, 235)'
			],
			borderWidth: 1,
			barPercentage: 0.5
		}],
		labels: [
			'7 Days',
			'14 Days',
			'30 Days',
			'60 Days',
			'90 Days'
		]
	},
	options: {
		responsive: true,
		maintainAspectRatio: true,
		scales: {
		  x: {
			ticks: {
				font: {
					family: 'Roboto Slab', 
					size: 14,
				}
            }
		  },
		  y: {
			beginAtZero: true,
			ticks: {
				font: {
					family: 'Roboto Slab', 
					size: 14,
				}
            }
		  }
		},
		plugins: {
            legend: {
                labels: {
                    font: {
						family: 'Roboto Slab', 
                        size: 14
                    }
                }
            }
        }
	}
};


document.addEventListener('DOMContentLoaded', function() {
    var total = dashboard_chart_config['data']['datasets'][0]['data'][3];
	var rest = dashboard_chart_config['data']['datasets'][0]['data'][0];
	rest += dashboard_chart_config['data']['datasets'][0]['data'][1];
	//rest += dashboard_chart_config['data']['datasets'][0]['data'][2];
	dashboard_chart_config['data']['datasets'][0]['data'][3] = total - rest;
}, false);

{{USERINFOJS}}
