<?php

///////////////////////////////////////////////////////////////////////////////


define('THIS_TOOL_NAME', 'index');

///////////////////////////////////////////////////////////////////////////////

include "includes/base-init.php";
include "includes/head-top.php"
?>

<body>

<div class="theme-select theme-bg" id="themechange"></div>
<div class="menu-select theme-bg" id="menuselect"></div>
<div id="contentwrap">
<?php include "includes/head-logo-toolbar.php" ?>
<?php include "includes/login-required.php" ?>
<div id="content">
	<div id="menucontrol">
<?php include "includes/index-sidebar.php" ?>
	</div>
	<div id="maincontent">
		<div class="tools-panel">
			<h1>Custom Tools</h1>
			<p>These tools are configured by the system administrator to streamline domain management. Administrators determine how domains can be added to the portfolio and how domain data can be exported in specific formats. Additional tools will be introduced in future releases.</p>
			<div class="tools-container">
				<a href="tools/add-domains.php" class="tool-box tool-add-domains">
					<span class="tool-icon" aria-hidden="true"></span>
					<div class="tool-content">
						<h3>Add Domains</h3>
						<p>
						Add domains one at a time or in bulk using CSV-formatted rows. Administrators can control which standard and custom column values may be provided together with each domain name.
						</p>

					</div>
				</a>

				<a href="tools/export-domains.php" class="tool-box tool-export-domains">
					<span class="tool-icon" aria-hidden="true"></span>
					<div class="tool-content">
						<h3>Export Domains</h3>
						<p>
						Export domain data to CSV with flexible column ordering, computed and custom columns, customizable headings, and a preview of the first 20 rows before export.
						</p>

					</div>
				</a>
			</div>
		</div>
	</div>
</div>
</div>

<?php
///////////////////////////////////////////////////////////////////////////////
$jsApiBaseUrl      = htmlspecialchars($apiBaseUrl, ENT_QUOTES, 'UTF-8');
///////////////////////////////////////////////////////////////////////////////
?>
<script>
var baseurl           = "<?php echo $baseUrl; ?>";
var API_BASE_URL      = <?php echo json_encode($jsApiBaseUrl); ?>;
</script>

<script type="text/javascript" src="tools/js/common.js"></script>
<script type="text/javascript" src="tools/js/index.js"></script>
</body>
</html>
