class SSLEdit {
	constructor(options={}) {
		if(!SSLEdit._instance) {
			this.init(options);
			SSLEdit._instance = this;
		}
		return SSLEdit._instance;
	}
	
	init(options) {
		this.options = options;
		new UserInput().eventHandler('#panel-ssledit', this);
	}
	
	show(ids, hosts) {
		var i18n = new Translator();
		
		this.options.ids = ids;
		this.options.hosts = hosts;
		var sc = $('.tcb-ssldatatable:checkbox:checked').length;
		if(sc) {
			$('.affected-rows').html(hosts);
			new PopupPanel("panel-ssledit");
			this.showStatus('');
			this.fillColumnNameRows();
		}
		else 
			PopupPanel.showPopup(i18n.__("Please select the rows to edit by checking the boxes for the corresponding entries in the data table."), i18n.__("No Rows Selected"));
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////
	
	showStatus(msg) {
		PopupPanel.showStatus('ssledit-error', msg);
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////
	
	reSize() {
		var th02 = 0;
		if($(window).width() >= 630) {
			$("#ssledit-pane02 > div").each(function(){
				th02 += $(this).outerHeight(true);
			});
			$('#ssledit-columns').css('height', th02);
		}
		else
			$('#ssledit-columns').css('height', 150);
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////
	
	columnRowClicked(itemdata) {
		var dv = '';
		var column = itemdata.item;
		$('#ssledit-column').html(column);
		this.data_column = column;
		var label = column.replaceAll('_', ' ');
		$('#ssledit-column-label').html('Label: ' + label);
		if(this.options.ids.length == 1) {
			var theid = this.options.ids[0];
			var dt = DataTableView.getTable("ssldatatable");
			var tabledata = dt.options.data;
			for(var row = 0; row < tabledata.length; row++) {
				var rowid = tabledata[row][dt.options.idcolumn];
				if(parseInt(rowid) == theid) {
					var value = tabledata[row][column];
					if(value !== undefined) {
						dv = value;
					}
				}
			}
		}
		$('#ssledit-value').val(dv);
	}
	
	submitSSLEdit() {
		this.showStatus('please wait');
		var field = this.data_column;
		var value = $('#ssledit-value').val();

		var ids = this.options.ids;
		var datastr = SEDAPI.construct("grid", "sslcerts", "edit");
		datastr += "&id=" + encodeURIComponent(ids.join(","));
		datastr += "&" + field + "=" + encodeURIComponent(value);
		console.log(datastr);
		SEDAPI.call(datastr, this.apiSSLEditDone.bind(this), null);
	}
	
	apiSSLEditDone(x, jqXHR, textStatus, params) {
		if(x != null) {
			if(x.status == 'ok') {
				if(x.edited > 0) {
					var dt = DataTableView.getTable("ssldatatable");
					dt.reload();
					if(this.options.ids.includes(dt.last_highlighted_rowid)) {
						if(dt.options.handlers && dt.options.handlers.select)
							dt.options.handlers.select(dt.last_highlighted_rowid);
					}
				}
				this.showStatus('ok');
			}
			else {
				this.showStatus(x.error);
			}
		}
	}
	
	fillColumnNameRows() {
		var columns = ['notes_a', 'notes_b', 'notes_c', 'notes_d'];
		var list = '';
		for(var i = 0; i < columns.length; i++) {
			var key = columns[i];
			list += '<li id="' + key + '">' + "<div class=\"datatable-column-selector\"><div class=\"column-type-string\"></div><div>"+ key + "</div></div></li>";
		}	
		$('#ssledit-columns').html(list);
		new ItemList('ssledit-columns', {click:this.columnRowClicked.bind(this)});
	}

}
	