<?php
header("Content-type: text/css");

$mode = "light";
if(isset($_REQUEST['mode'])) {
	$mode = strtolower($_REQUEST['mode']);
	if($mode !== "light" && $mode !== "dark")
		$mode = "light";
}

$transparency = 5;
$blurpixels = 5;
if(isset($_REQUEST['bl'])) {
	$blurpixels = intval($_REQUEST['bl']);
	$blurpixels = ($blurpixels < 0) ? 0 : (($blurpixels > 15) ? 15 : $blurpixels);
}
if(isset($_REQUEST['tr'])) {
	$transparency = intval($_REQUEST['tr']);
	$transparency = ($transparency < 0) ? 0 : (($transparency > 15) ? 15 : $transparency);
}

$mint = ($mode == 'light') ? 0.85 : 0.5;
$c_alpha = getRGBAlpha($mint, 15-$transparency, 15);
$p_alpha = getRGBAlpha(0.95, 15-$transparency, 15);
$cbdfilter = ($blurpixels == 0 || $transparency == 0) ? 'unset' : 'blur(' . $blurpixels . 'px)';

if($mode == 'dark') {
	$cbgcolor  = "rgba(0,0,0,$c_alpha)";
	$pbgcolor  = "rgba(0,0,0,$p_alpha)";
}
else {
	$cbgcolor  = "rgba(253,255,253,$c_alpha)";
	$pbgcolor  = "rgba(255,255,255,$p_alpha)";
}

echo(":root {--content-background-color:$cbgcolor;--popup-background-color:$pbgcolor;--content-backdrop-filter:$cbdfilter}");


function getRGBAlpha($base_alpha, $transparency, $tiks) {
	return $base_alpha + ((1.0 - $base_alpha)/$tiks)*$transparency;
}
