<?php
###############################################################################
# Ping.php
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
#
############################################################################### 

namespace 	CodePunch\LU;
use 		CodePunch\Base\Util as UTIL;
use			CodePunch\Base\Text as TEXT;

###############################################################################

class Ping  {
	
	private $lookupManager = null;
	
	###########################################################################
	
	public function __construct($lum=null) {
		$this->lookupManager = $lum;
	}
	
	###############################################################################

	public function Ping(&$ludata)
	{
		$db = $this->lookupManager->getAuthentication()->getDatabase();
		$did = $ludata['sid'];
		$domain = $db->getDomainName($did);
		$lookupcount = 0;
		if($did !== false && $did > 0) {
			$dataarray = $this->get_ping_response($did, $domain, "");
			if(count($dataarray)) {
				$status = $this->lookupManager->updateDomainTable(\CodePunch\LU\LookupManager::PING_RESPONSE, $dataarray);
				if($status !== false)
					$lookupcount++;
			}
		}
		$ludata['status'] = \CodePunch\LU\LookupManager::LUQ_COMPLETE;
		return $lookupcount;
	}
	
	###############################################################################

	private function get_ping_response($did, $domain, $subdomain="www")
	{
		$host = UTIL::idn_convert_to_host_name($domain, $subdomain);
		$url  = $host;
		
		$data_array = Array();
		$starttime = microtime(true);
		$file      = @fsockopen ($url, 80, $errno, $errstr, 10);
		$stoptime  = microtime(true);
		$status    = 0;
		if (!$file) {
			$status = -1;  // Site is down
		}
		else 
		{
			fclose($file);
			$status = ($stoptime - $starttime) * 1000;
			$status = floor($status);
		}
		$db = $this->lookupManager->getAuthentication()->getDatabase();
		$disableAlerts = $db->findOneOf($db->getDomainTableName(), "sid", $did, "disable_alerts");
		if($disableAlerts !== false && intval($disableAlerts) == 1)
			UTIL::debug_cli_print("Ignoring Ping Alerts for " . $domain);
		else
			$this->lookupManager->emailPingAlerts($did, $host, $status);
		$data_array['pingtime'] = $status;
		$data_array['ping_checked_at'] = date("Y-m-d H:i:s");
		$data_array['domain'] = $domain;
		return $data_array;
	}

}

###############################################################################
