<?php
###############################################################################
# Audit.php
#
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
#
############################################################################### 

namespace 	CodePunch\DB;

use 		CodePunch\Base\Util as UTIL;
use			CodePunch\Base\Text as TEXT;
use 		Exception;

###############################################################################

class Audit {
	
	const ADD_DOMAINS 				= 1;
	const DELETE_DOMAINS 			= 2;
	const LOGGED_IN					= 3;
	const LOGGED_OUT				= 4;
	const SESSION_TIMEOUT			= 5;
	const ADD_USER					= 6;
	const DELETE_USER				= 7;
	const ADD_CATEGORY				= 8;
	const DELETE_CATEGORY			= 9;
	const EDIT_DOMAIN				= 10;
	const ADD_AUTOQUERY				= 11;
	const DELETE_AUTOQUERY			= 12;
	const EDIT_AUTOQUERY			= 13;
	const DOMAIN_CSV_DOWNLOAD		= 14;
	const SSL_CSV_DOWNLOAD			= 15;
	const DNS_CSV_DOWNLOAD			= 16;
	const DNS_RECORD_CHANGE 		= 17;
	const REPORT_EMAILED			= 18;
	const EDIT_CATEGORY				= 19;
	const DELETE_SUBDOMAIN			= 20;
	const ADD_SUBDOMAIN				= 21;
	const EDIT_SUBDOMAIN			= 22;
	const REGISTRAR_PROFILE_CREATED = 23;
	const REGISTRAR_PROFILE_EDITED	= 24;
	const REGISTRAR_PROFILE_DELETED = 25;
	const IMPORT_CSV_DATA			= 26;
	const SCHEDULE_LOOKUPS			= 27;
	const DELETE_LOOKUP_QUEUE		= 28;
	const ADD_CUSTOM_COLUMN			= 29;
	const DELETE_CUSTOM_COLUMN		= 30;
	const REPAIR_DOMAIN_COLUMN		= 31;
	const REPAIR_SUBDOMAIN_COLUMN	= 32;
	const APP_UPDATE_DBCHECK		= 33;
	const PING_ATTEMPT_FAIL			= 34;
	const PING_STATUS_CHANGE		= 35;
	const HTTP_STATUS_FAIL			= 36;
	const HTTP_STATUS_CHANGE		= 37;
	const DOMAIN_NEW_REGISTRATION	= 38;
	const DOMAIN_RENEWAL			= 39;
	const DOMAIN_REGISTRAR_NS_SET	= 40;

	const EMAIL_ATTEMPT_FAIL		= 200;
	const LOGIN_ATTEMPT_FAIL		= 201;
	const LOGIN_2FA_SUCCESS			= 203;
	const LOGIN_2FA_FAIL			= 204;
	const DNS_CHECK_TIMEOUT			= 205;
	const GENERIC_ACTION			= 255;
	
	###########################################################################
	
	public $database = null;
	
	###########################################################################
	
	public function __construct($db)
	{ 
		$this->database = $db;
	}
	
	###########################################################################
	
	public static function getDescription($action)
	{
		switch($action)
		{
			case self::ADD_DOMAINS: // 1
				return TEXT::get("audit_added_domains");
			case self::DELETE_DOMAINS: //2
				return TEXT::get("audit_deleted_domain");
			case self::LOGGED_IN: //3
				return TEXT::get("audit_logged_in");
			case self::LOGGED_OUT: //4
				return TEXT::get("audit_logged_out");
			case self::SESSION_TIMEOUT: //5
				return TEXT::get("audit_session_timedout");
			case self::ADD_USER: // 6
				return TEXT::get("audit_added_user");
			case self::DELETE_USER: // 7
				return TEXT::get("audit_deleted_user");
			case self::ADD_CATEGORY: // 8
				return TEXT::get("audit_added_category");
			case self::DELETE_CATEGORY: // 9
				return TEXT::get("audit_deleted_category");
			case self::EDIT_DOMAIN: // 10
				return TEXT::get("audit_edited_domain");
			case self::ADD_AUTOQUERY: // 11
				return TEXT::get("audit_added_autoquery");
			case self::DELETE_AUTOQUERY: // 12
				return TEXT::get("audit_edited_autoquery");
			case self::EDIT_AUTOQUERY: // 13
				return TEXT::get("audit_edited_autoquery");
			case self::DOMAIN_CSV_DOWNLOAD: // 14
				return TEXT::get("audit_downloaded_domain_csv");
			case self::SSL_CSV_DOWNLOAD: // 15
				return TEXT::get("audit_downloaded_ssl_csv");
			case self::DNS_CSV_DOWNLOAD: // 16
				return TEXT::get("audit_downloaded_dns_csv");
			case self::DNS_RECORD_CHANGE: // 17
				return TEXT::get("audit_changed_dns_record");
			case self::REPORT_EMAILED: // 18
				return TEXT::get("audit_emailed_report");
			case self::EDIT_CATEGORY: // 19
				return TEXT::get("audit_edited_category");
			case self::DELETE_SUBDOMAIN: // 20
				return TEXT::get("audit_delete_subdomain");
			case self::ADD_SUBDOMAIN: // 21
				return TEXT::get("audit_add_subdomain");
			case self::EDIT_SUBDOMAIN: // 22
				return TEXT::get("audit_edit_subdomain");
			case self::REGISTRAR_PROFILE_CREATED: // 23
				return TEXT::get("audit_created_registrar_api_profile");
			case self::REGISTRAR_PROFILE_EDITED: // 24
				return TEXT::get("audit_edited_registrar_api_profile");
			case self::REGISTRAR_PROFILE_DELETED: // 25
				return TEXT::get("audit_deleted_registrar_api_profile");
			case self::IMPORT_CSV_DATA: // 26
				return TEXT::get("audit_imported_csv_data");
			case self::SCHEDULE_LOOKUPS: // 27
				return TEXT::get("audit_scheduled_lookups");
			case self::DELETE_LOOKUP_QUEUE: // 28
				return TEXT::get("audit_deleted_lookup_queue");
			case self::ADD_CUSTOM_COLUMN: // 29
				return TEXT::get("audit_added_custom_column");
			case self::DELETE_CUSTOM_COLUMN: // 30
				return TEXT::get("audit_deleted_custom_column");
			case self::REPAIR_DOMAIN_COLUMN: // 31
				return TEXT::get("audit_repaired_domain_column");
			case self::REPAIR_SUBDOMAIN_COLUMN: // 32
				return TEXT::get("audit_repaired_subdomain_column");
			case self::APP_UPDATE_DBCHECK: //33
				return TEXT::get("audit_checking_database_on_app_update");
			case self::PING_ATTEMPT_FAIL: //34
				return TEXT::get("audit_ping_attempt_failed");
			case self::PING_STATUS_CHANGE: //35
				return TEXT::get("audit_ping_status_changed");
			case self::HTTP_STATUS_FAIL: //36
				return TEXT::get("audit_http_status_failed");
			case self::HTTP_STATUS_CHANGE: //37
				return TEXT::get("audit_http_status_changed");
			case self::DOMAIN_NEW_REGISTRATION: //38
				return TEXT::get("audit_domain_registered");
			case self::DOMAIN_RENEWAL: //39
				return TEXT::get("audit_domain_renewed");
			case self::DOMAIN_REGISTRAR_NS_SET: //40
				return TEXT::get("audit_name_servers_changed _at_registrar");

			case self::EMAIL_ATTEMPT_FAIL: // 200
				return TEXT::get("audit_failed_email_attempt");
			case self::LOGIN_ATTEMPT_FAIL:	// 201
				return TEXT::get("audit_failed_login_attempt");
			case self::LOGIN_2FA_SUCCESS: // 203
				return TEXT::get("audit_2fa_login_succeeded");
			case self::LOGIN_2FA_FAIL: // 204
				return TEXT::get("audit_failed_2fa_login");
			case self::DNS_CHECK_TIMEOUT: // 205
				return TEXT::get("dns_check_timed_out");
			
			default:
				return TEXT::get("audit_unknown");
		}
	}
	
	###########################################################################
	
	public function log($action, $description=null, $params=null)
	{
		$count = 0;
		if($this->database != null) {
			if($description  != null && is_array($description)) {
				foreach($description as $desc) {
					$status = $this->database->auditLog($action, $desc, $params);
					$count += $status ? 1 : 0;
				}
			}
			else {
				$status = $this->database->auditLog($action, $description, $params);
				$count += $status ? 1 : 0;
			}
		}
		return $count;
	}
	
	###########################################################################
	
	public static function add($db, $action, $description=null, $params=null)
	{
		if($db) {
			$audit = new \CodePunch\DB\Audit($db);
			$audit->log($action, $description, $params);
		}
	}
	
	###########################################################################
}

