class BulkEdit{constructor(options={}){if(!BulkEdit._instance){this.init(options);BulkEdit._instance=this;}
return BulkEdit._instance;}
init(options){this.options=options;new UserInput().eventHandler('#panel-bulkedit',this);}
getSubdomains(sourcetable,domain){var subdomains=[];var dt=DataTableView.getTable(sourcetable);if(dt){this.hids=[parseInt(dt.last_highlighted_rowid)];for(var i=0;i<dt.options.data.length;i++){var hid=parseInt(dt.options.data[i].id);if(this.hids.includes(hid))
subdomains.push(dt.options.data[i]['s.subdomain']+'.'+domain);}}
return subdomains;}
show(source="domain",columns,selected){var i18n=new Translator();this.source=source;this.options.selected=undefined;if(columns!==undefined&&columns.length){this.options.validcolumns=columns;if(selected===undefined)
selected=columns[0];}
else
this.options.validcolumns=undefined;if(selected!==undefined&&this.options.validcolumns!==undefined&&this.options.validcolumns.includes(selected))
this.options.selected=selected;var dt=this.options.panels.details.domaintable;var sc=dt.getSelectedDomainCount();if(sc){if(this.source=="dns"||this.source=="ssl"){var domainid=getCookieInt(COOKIE_SELECTED_DOMAIN_ID,0);this.ids=[domainid];var domain=this.options.panels.details.current_selected_domain;var subdomains=this.getSubdomains(this.source+'table',domain);var affected=subdomains.join(', ');}
else if(this.source=="sslcerts"){}
else{this.ids=dt.getSelectedIds();var affected=dt.getAffectedDomainsText();}
$('.affected-domains').html(affected);new PopupPanel("panel-bulkedit");this.showStatus('');this.fillColumnNameRows();}
else
PopupPanel.showPopup(i18n.__("Please select the domains to edit by checking the boxes for the corresponding entries in the data table."),i18n.__("No Domains Selected"));if(this.source=="domain")
$('.event-resetEditFlag').show();else
$('.event-resetEditFlag').hide();}
showStatus(msg){PopupPanel.showStatus('bulkedit-error',msg);}
reSize(){var th02=0;if($(window).width()>=630){$("#bulkedit-pane02 > div").each(function(){th02+=$(this).outerHeight(true);});$('#bulkedit-columns').css('height',th02);}
else
$('#bulkedit-columns').css('height',150);}
columnRowClicked(itemdata){var column=itemdata.item;$('#bulkedit-column').html(column);this.data_column=column;var label=this.domain_column_labels[column];$('#bulkedit-column-label').html('Label: '+label);$('#bulkedit-value').val('');if(this.source=="domain"){var dt=this.options.panels.details.domaintable;var sc=dt.getSelectedDomainCount();var theid=this.ids[0];}
else{var dt=DataTableView.getTable(this.source+'table');var sc=1;var theid=this.hids[0];}
if(sc==1){var tabledata=dt.options.data;for(var row=0;row<tabledata.length;row++){var rowid=tabledata[row][dt.options.idcolumn];if(parseInt(rowid)==theid){var value=tabledata[row][column];if(value===undefined&&this.source=='domain')
value=tabledata[row]['d.'+column];if(value===undefined&&this.source!='domain')
value=tabledata[row]['s.'+column];if(value!==undefined){$('#bulkedit-value').val(value);}}}}}
resetEditFlag(){var ids=this.ids;var datastr=SEDAPI.construct("set","domain","edit");datastr+="&id="+encodeURIComponent(ids.join(","));datastr+="&columns="+encodeURIComponent("manual_edited_at");datastr+="&data="+encodeURIComponent("null");SEDAPI.call(datastr,this.apiBulkEditDone.bind(this),null);}
submitBulkEdit(){this.showStatus('please wait');var field=this.data_column;var value=$('#bulkedit-value').val();if(this.source=="domain"){var ids=this.ids;var datastr=SEDAPI.construct("set","domain","edit");datastr+="&id="+encodeURIComponent(ids.join(","));datastr+="&columns="+encodeURIComponent(field);datastr+="&data="+encodeURIComponent(value);SEDAPI.call(datastr,this.apiBulkEditDone.bind(this),null);}
else{var ids=this.hids;var datastr=SEDAPI.construct("grid",this.source,"edit");datastr+="&id="+encodeURIComponent(this.hids[0]);datastr+="&"+field+"="+encodeURIComponent(value);SEDAPI.call(datastr,this.apiSubdomainEditDone.bind(this),null);}}
apiBulkEditDone(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){if(x.updated>0){var dt=this.options.panels.details.domaintable;dt.reload();if(this.ids.includes(dt.last_highlighted_rowid))
this.options.panels.details.showDomain(dt.last_highlighted_rowid);}
this.showStatus('ok');}
else{this.showStatus(x.error);}}}
apiSubdomainEditDone(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){var dt=DataTableView.getTable(this.source+'table');if(dt)
dt.reload();this.showStatus('ok');}
else{this.showStatus(x.error);}}}
fillColumnNameRows(){var source=this.source;if(this.source=="dns"|this.source=="ssl")
source="subdomain";var datastr=SEDAPI.construct("list",source,"columns");if(this.source=='dns')
datastr+="&grid=dns";else if(this.source=='ssl')
datastr+="&grid=ssl";SEDAPI.call(datastr,this.apiColumnDataReceived.bind(this),null);}
apiColumnDataReceived(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){var list=this.getColumnList(x.columns,this.options.validcolumns);$('#bulkedit-columns').html(list);new ItemList('bulkedit-columns',{click:this.columnRowClicked.bind(this)});if(this.options.selected===undefined)
this.options.selected=$("#bulkedit-columns li:nth-child(1)").attr('id');$('#'+this.options.selected).addClass('active');this.columnRowClicked({list:'bulkedit-columns',item:this.options.selected});this.reSize();}}}
getColumnList(columns,validcolumns){this.default_domain_columns=[];this.custom_domain_columns=[];this.domain_column_labels=[];this.domain_data_columns=columns;if(validcolumns!==undefined&&validcolumns.length){for(var i=0;i<validcolumns.length;i++){var key=validcolumns[i];if(columns.hasOwnProperty(key)){var label=columns[key]['label'];var gridview=parseInt(columns[key]['gridview']);var editable=parseInt(columns[key]['editable']);var custom=parseInt(columns[key]['custom']);if(!custom&&gridview&&editable){if(key!='r_h_disp')
this.default_domain_columns.push(key);}
else if(custom)
this.custom_domain_columns.push(key);this.domain_column_labels[key]=decodeURIComponent(label);}}}
else{for(var key in columns){if(key==='length'||!columns.hasOwnProperty(key)||key==='domain')continue;var label=columns[key]['label'];var ftype=columns[key]['fieldtype'];var gridview=parseInt(columns[key]['gridview']);var editable=parseInt(columns[key]['editable']);var custom=parseInt(columns[key]['custom']);if(!custom&&gridview&&editable){if(key!='r_h_disp')
this.default_domain_columns.push(key);}
else if(custom)
this.custom_domain_columns.push(key);this.domain_column_labels[key]=decodeURIComponent(label);}}
return this.constructList(columns);}
constructList(columns){var list='';for(var i=0;i<this.custom_domain_columns.length;i++){var key=this.custom_domain_columns[i];var fieldclass='column-type-'+columns[key]['fieldtype']+"-custom";list+='<li id="'+key+'">'+"<div class=\"datatable-column-selector\"><div class=\""+fieldclass+"\"></div><div>"+key+"</div></div></li>";}
for(var i=0;i<this.default_domain_columns.length;i++){var key=this.default_domain_columns[i];var fieldclass='column-type-'+columns[key]['fieldtype'];list+='<li id="'+key+'">'+"<div class=\"datatable-column-selector\"><div class=\""+fieldclass+"\"></div><div>"+key+"</div></div></li>";}
return list;}}
class CategorizeDomains{constructor(options={}){if(!CategorizeDomains._instance){this.init(options);CategorizeDomains._instance=this;}
return CategorizeDomains._instance;}
init(options){this.options=options;new UserInput().eventHandler('#panel-categorize',this);}
show(){var dt=this.options.panels.details.domaintable;var sc=dt.getSelectedDomainCount();if(sc){this.ids=dt.getSelectedIds();$('.affected-domains').html(dt.getAffectedDomainsText());new PopupPanel("panel-categorize");this.showStatus('');this.getCategoryList();}
else
PopupPanel.showPopup("Please select the domains to categorize","No Domains Selected");}
showStatus(msg){PopupPanel.showStatus('categorize-error',msg);}
getCategoryList(){var index=1;var listhtml='';var catlist=this.options.panels.controls.categories;for(var i=0;i<catlist.length;i++){if(catlist[i].cid!=1){var caticon=catlist[i].caticon.replace(".png","").toLowerCase();var sortclass="";listhtml+="<li tabindex=\"0\" data-index=\""+index+"\" data-id=\""+catlist[i].cid+"\"><div class=\"category-list-row-single-column list-icon-"+caticon+sortclass+"\">"+catlist[i].name+"</div></li>";if(this.category_users&&!this.category_users.hasOwnProperty(catlist[i].cid))
this.category_users[catlist[i].cid]=[];index++;}}
$('#categorize-category').html(listhtml);$('#categorize-category li').removeClass('active');new ItemList('categorize-category',{checkbox:true});}
addToCategories(){var cids=ItemList.getItemList('categorize-category').getSelectionIds();if(cids.length){var datastr=SEDAPI.construct("admin","category","add");datastr+="&id="+encodeURIComponent(this.ids.join(","));datastr+="&cid="+encodeURIComponent(cids.join(','));SEDAPI.call(datastr,this.apiCategorizeDone.bind(this),null);}}
removeFromCategories(){var cids=ItemList.getItemList('categorize-category').getSelectionIds();if(cids.length){var datastr=SEDAPI.construct("admin","category","remove");datastr+="&id="+encodeURIComponent(this.ids.join(","));datastr+="&cid="+encodeURIComponent(cids.join(','));SEDAPI.call(datastr,this.apiCategorizeDone.bind(this),null);}}
apiCategorizeDone(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){this.options.panels.controls.getCategoriesList(1,this.ids);this.showStatus('ok');}
else
this.showStatus(x.error);}}}
class ColumnSetup{constructor(options={}){if(!ColumnSetup._instance){this.init(options);ColumnSetup._instance=this;}
return ColumnSetup._instance;}
init(options){this.options=options;new UserInput().eventHandler('#panel-columnsetup',this);}
show(){new PopupPanel("panel-columnsetup");this.showStatus('');var dgroup=getCookie(COOKIE_CURRENT_DISPLAY_GROUP,"date");this.fillColumnNameRows(dgroup);}
showStatus(msg){PopupPanel.showStatus('columnsetup-error',msg);}
columnRowClicked(){}
rowsSorted(){}
submitColumns(){var lb=ItemList.getItemList('domain-table-columns');var checkedIds=lb.getSelectionIds();var dgroup=this.current_display_group+'_columns_array';var datastr=SEDAPI.construct("set","domain","colmodel");datastr+="&group="+encodeURIComponent(dgroup);var colsetup="";var length=checkedIds.length;var columns=new Array();for(var i=0;i<length;i++){columns[i]=checkedIds[i];colsetup+=columns[i];if(i!=(length-1))
colsetup+=";";}
this.showStatus("Please wait");datastr+="&columns="+encodeURIComponent(colsetup);SEDAPI.call(datastr,this.apiColumnSetupDone.bind(this),this.current_display_group);}
resetColumns(){var dgroup=this.current_display_group+'_columns_array';var datastr=SEDAPI.construct("set","domain","colmodel");datastr+="&group="+encodeURIComponent(dgroup);datastr+="&columns=";this.showStatus("Please wait");SEDAPI.call(datastr,this.apiColumnSetupDone.bind(this),this.current_display_group);}
apiColumnSetupDone(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){this.showStatus('OK');window[params+'_columns_array']=x.colmodel;this.options.panels.details.domaintable.setColumns(window[params+'_columns_array']);if(x.columns=='reset')
PopupPanel.hidePanel("panel-columnsetup");}
else
this.showStatus(x.error);}}
fillColumnNameRows(dgroup){this.current_display_group=dgroup;var datastr=SEDAPI.construct("list","domain","columns");SEDAPI.call(datastr,this.apiFillDomainDataColumns.bind(this),dgroup);}
apiFillDomainDataColumns(x,jqXHR,textStatus,params){var list="";if(x.status=='ok'){var datacolumns=this.options.panels.details.domaintable.options.columns;var exists=[];var index=1;var colnum=datacolumns.length;for(var i=0;i<colnum;i++){if(datacolumns[i].name!="rn"&&datacolumns[i].name!="cb"&&datacolumns[i].name!="domain"){var key=datacolumns[i].name;var label=datacolumns[i].label;exists.push(key);var fieldclass='';var pkey=key;if(!x.columns.hasOwnProperty(pkey))
pkey=pkey.replace('d.','');if(x.columns.hasOwnProperty(pkey)){var ftype=x.columns[pkey]['fieldtype'];fieldclass='column-type-'+ftype;fieldclass+=parseInt(x.columns[pkey]['custom'])?'-custom':'';}
if(key!=='r_h_disp'&&key!=='d.r_h_disp'&&key!="dt_ser_num"&&key!="d.domain"){list+="<li tabindex=\"0\" data-index=\""+index+"\" data-id=\""+key+"\"><div class=\"datatable-column-selector\"><div class=\""+fieldclass+"\"></div><div>"+label+"</div></div></li>\n";index++;}}}
var currentcolumns=exists;for(var key in x.columns){if(key==='length'||!x.columns.hasOwnProperty(key)||key=="domain")continue;var custom=parseInt(x.columns[key]['custom']);if(!custom)continue;if(exists.indexOf(key)>=0||exists.indexOf(key.replace("d.",""))>=0||exists.indexOf("d."+key)>=0)
continue;var label=x.columns[key]['label'];var ftype=x.columns[key]['fieldtype'];var gridview=parseInt(x.columns[key]['gridview']);var editable=parseInt(x.columns[key]['editable']);var fieldclass='column-type-'+ftype+'-custom';if(gridview!=0&&key!="dt_ser_num"&&key!="d.domain"&&key!="r_h_disp"&&key!=='d.r_h_disp'&&exists.indexOf(key)<0){list+="<li tabindex=\"0\" data-index=\""+index+"\" data-id=\""+key+"\"><div class=\"datatable-column-selector\"><div class=\""+fieldclass+"\"></div><div>"+label+"</div></div></li>\n";index++;}}
for(var key in x.columns){if(key==='length'||!x.columns.hasOwnProperty(key)||key=="domain")continue;var custom=parseInt(x.columns[key]['custom']);if(custom)continue;if(exists.indexOf(key)>=0||exists.indexOf(key.replace("d.",""))>=0||exists.indexOf("d."+key)>=0)
continue;var label=x.columns[key]['label'];var ftype=x.columns[key]['fieldtype'];var gridview=parseInt(x.columns[key]['gridview']);var editable=parseInt(x.columns[key]['editable']);var fieldclass='column-type-'+ftype;if(gridview!=0&&key!="dt_ser_num"&&key!="d.domain"&&key!="r_h_disp"&&key!=='d.r_h_disp'&&exists.indexOf(key)<0){list+="<li tabindex=\"0\" data-index=\""+index+"\" data-id=\""+key+"\"><div class=\"datatable-column-selector\"><div class=\""+fieldclass+"\"></div><div>"+label+"</div></div></li>\n";index++;}}}
else{}
$('#domain-table-columns').html(list);var instance=this;var lb=new ItemList('domain-table-columns',{click:function(itemdata){instance.columnRowClicked(itemdata);},sortable:true,checkbox:true,onsort:function(itemid,ui){instance.rowsSorted(itemid,ui);},nosort:'nosort'});lb.setSelectionIds(currentcolumns);}}
class ControlsPane{constructor(options){this.options=options;this.current_category_id=getCookieInt(COOKIE_CURRENT_CATEGORY_ID,1);this.current_autoquery_id=getCookieInt(COOKIE_CURRENT_AUTOQUERY_ID,1);this.current_control_tab=getCookie(COOKIE_CATEGORY_CONTROL_TAB,'categories');this.options.categories={};this.options.autoqueries={};this.options.categories.sort=getCookie(COOKIE_CATEGORY_LIST_SORT,'sortindex-asc');this.options.autoqueries.sort=getCookie(COOKIE_AUTOQUERY_LIST_SORT,'sortindex-asc');this.categories=null;this.autoqueries=null;this.category_users=null;let ui=new UserInput();ui.eventHandler('.controlfooter',this);ui.eventHandler('.catpanes',this);this.getCategoryIcons();this.init();}
init(){this.getCategoriesList();var instance=this;new TabView('controltab',{change:function(current){let switch_display_on_control_tab_change=false;instance.resizeApp();if(switch_display_on_control_tab_change){if(current=="categories")
instance.categoryRowClicked(instance.current_category_id);else
instance.queryRowClicked(instance.current_autoquery_id);}
else if(instance.current_control_tab!=current){if(current=="categories")
$('#categorylist li').removeClass('active');else
$('#querylist li').removeClass('active');}},current:instance.current_control_tab});new ItemList('categorylist',{click:function(itemdata){instance.categoryRowClicked(itemdata);},sortable:true,onsort:function(itemid,ui){instance.categoryListSorted(itemid,ui);},nosort:'nosort'});new ItemList('querylist',{click:function(itemdata){instance.queryRowClicked(itemdata);},sortable:true,onsort:function(itemid,ui){instance.categoryListSorted(itemid,ui);},nosort:'nosort'});}
resizeApp(){if(this.options.handlers!=undefined&&this.options.handlers.resize!=undefined)
this.options.handlers.resize();}
onChange(csel){if(this.options.handlers!=undefined&&this.options.handlers.change!=undefined)
this.options.handlers.change(csel);}
categoryListSorted(itemid,ui=undefined){if((itemid=="categorylist"&&this.options.categories.sort=='sortindex-asc')||(itemid=="querylist"&&this.options.autoqueries.sort=='sortindex-asc')){this._categoryListSorted(itemid);}}
_categoryListSorted(itemid){var ids=[];var listItems=$("#"+itemid+" li");listItems.each(function(idx,li){var id=$(li).attr('id').replace("catlist-","").replace("querylist-","");ids.push(id);});var target=(itemid=="categorylist")?"category":"query";var datastr=SEDAPI.construct("set",target,"sort");datastr+="&id="+encodeURIComponent(ids);SEDAPI.call(datastr,this.apiCategoryOrQuerySortOrderSaved.bind(this),null);}
apiCategoryOrQuerySortOrderSaved(x,jqXHR,textStatus,params){if(x!=null&&x.status=="ok"){}}
getCategory(rowid){if(rowid==undefined)
rowid=this.current_category_id;if(rowid>0)
return this.categories.find(c=>c.cid==rowid);return undefined;}
getAutoquery(rowid){if(rowid==undefined)
rowid=this.current_autoquery_id;if(rowid>0)
return this.autoqueries.find(c=>c.id==rowid);return undefined;}
categoryRowClicked(itemdata){if(typeof itemdata=="object"&&typeof itemdata.item!="undefined")
var cid=itemdata.item.replace('catlist-',"");else
var cid=itemdata;if(typeof cid!="undefined"){this.current_category_id=cid;saveCookie(COOKIE_CURRENT_CATEGORY_ID,this.current_category_id);this.current_control_tab='categories';saveCookie(COOKIE_CATEGORY_CONTROL_TAB,this.current_control_tab);this.onChange({tab:'categories',id:this.current_category_id});}}
queryRowClicked(itemdata){if(typeof itemdata=="object"&&typeof itemdata.item!="undefined")
var aqid=itemdata.item.replace('querylist-',"");else
var aqid=itemdata;if(typeof aqid!="undefined"){this.current_autoquery_id=aqid;saveCookie(COOKIE_CURRENT_AUTOQUERY_ID,this.current_autoquery_id);this.current_control_tab='queries';saveCookie(COOKIE_CATEGORY_CONTROL_TAB,this.current_control_tab);this.onChange({tab:'queries',id:this.current_autoquery_id});}}
drawCategoryList(domaincids){if(domaincids.length){var cids=domaincids.map(String);$('#categorylist .category-list-row').each(function(){$(this).css('background-image','');$(this).removeClass('highlighted-category');var catname=$(this).text();var cid=$(this).attr('id').replace('catlist-','');if(cids.includes(cid)){var _sBg=$(this).css('background-image');$(this).css('background-image','url(lib/layouts/images/icons/categories/light/folders/checked-overlay.png), '+_sBg);$(this).addClass('highlighted-category');}});}}
getCategoriesList(mode=3){if(mode==3||mode==1){var sopt=this.options.categories.sort.split('-');let sortindex=sopt[0];let sortorder=sopt[1];var datastr=SEDAPI.construct("grid","category","");datastr+="&columns=name,cid,sortindex,caticon,dcount&sidx="+sortindex+"&sord="+sortorder+"&rows=1000";SEDAPI.call(datastr,this.apiGotCategoryGrid.bind(this),null);}
if(mode==3||mode==2){let sopt=this.options.autoqueries.sort.split('-');let sortindex=sopt[0];let sortorder=sopt[1];datastr=SEDAPI.construct("grid","query","");datastr+="&columns=id,name,sortindex,qicon,query,params&sidx="+sortindex+"&sord="+sortorder+"&rows=1000";SEDAPI.call(datastr,this.apiGotQueryGrid.bind(this),null);}}
apiGotCategoryGrid(x,jqXHR,textStatus,params){if(x!=null){if(x.records){var listhtml='';var catlist=x.rows;for(var i=0;i<x.rows.length;i++){if(x.rows[i].cid==1){var caticon="folder-all-domains";var sortclass=" nosort";listhtml+="<li tabindex=\"0\" id=\"catlist-"+x.rows[i].cid+"\" class=\"category-list-row list-icon-"+caticon+sortclass+"\"><div>"+x.rows[i].name+"</div><div>"+x.rows[i].dcount+"</div></li>";break;}}
for(var i=0;i<x.rows.length;i++){if(x.rows[i].cid!=1){var caticon=x.rows[i].caticon.replace(".png","").toLowerCase();var sortclass="";listhtml+="<li tabindex=\"0\" id=\"catlist-"+x.rows[i].cid+"\" class=\"category-list-row list-icon-"+caticon+sortclass+"\"><div>"+x.rows[i].name+"</div><div>"+x.rows[i].dcount+"</div></li>";if(this.category_users&&!this.category_users.hasOwnProperty(x.rows[i].cid))
this.category_users[x.rows[i].cid]=[];}}
$('#categorylist').html(listhtml);$('#categorylist li').removeClass('active');$('#catlist-'+this.current_category_id).addClass('active');this.categories=x.rows;if(this.options.handlers!=undefined&&this.options.handlers.drawCategoryList!=undefined)
this.options.handlers.drawCategoryList();if(this.options.handlers!=undefined&&this.options.handlers.dataInit!=undefined)
this.options.handlers.dataInit('categories');this.resizeApp();}}}
apiGotQueryGrid(x,jqXHR,textStatus,params){if(x!=null){if(x.records){var listhtml='';for(var i=0;i<x.rows.length;i++){if(x.rows[i].id==1){var qicon="folder-all-queries";var sortclass=" nosort";listhtml+="<li tabindex=\"0\" id=\"querylist-"+x.rows[i].id+"\" class=\"query-list-row list-icon-"+qicon+sortclass+"\"><div>"+x.rows[i].name+"</div><div></div></li>";break;}}
for(var i=0;i<x.rows.length;i++){if(x.rows[i].id!=1){var qicon=x.rows[i].qicon.replace(".png","");var sortclass="";listhtml+="<li tabindex=\"0\" id=\"querylist-"+x.rows[i].id+"\" class=\"query-list-row list-icon-"+qicon+sortclass+"\"><div>"+x.rows[i].name+"</div><div></div></li>";}}
$('#querylist').html(listhtml);$('#querylist li').removeClass('active');$('#querylist-'+this.current_autoquery_id).addClass('active');this.autoqueries=x.rows;if(this.options.handlers!=undefined&&this.options.handlers.dataInit!=undefined)
this.options.handlers.dataInit('queries');this.resizeApp();}}}
getCategoryIcons(){var datastr=SEDAPI.construct("get","category","info");datastr+="&users=yes";SEDAPI.call(datastr,this.apiGetCategoryInfoDone.bind(this),null);}
apiGetCategoryInfoDone(x,jqXHR,textStatus,params){if(x!=null&&x.status=='ok'){this.category_users={};for(var i=0;i<x.ids.length;i++){var cid=x.ids[i].id;var uids=x.ids[i].userids;if(cid!=1){this.category_users[cid]=uids.map(String);}}
var icons=x.icons;var iconhtml='';var sorted=[];for(var i=0;i<icons.length;i++){var ic=icons[i];if(ic.includes('folder-'))
sorted.push(ic);}
for(var i=0;i<icons.length;i++){var ic=icons[i];if(!ic.includes('folder-'))
sorted.push(ic);}
for(var i=0;i<sorted.length;i++){var label=sorted[i].replace(".png","");iconhtml+="<option class=\"list-icon-"+label+"\" value=\""+sorted[i]+"\">"+label+"</select>";}
$('.category-folder-icon-list').html(iconhtml);var userhtml='';var selects=[];var index=0;if(x.users){for(var i=0;i<x.users.length;i++){var name=x.users[i].name;var id=x.users[i].id;var admin=x.users[i].admin;if(!admin){userhtml+="<li tabindex=\"0\" data-id=\""+id+"\" data-index=\""+index+"\" class=\""+"\">"+name+"</li>\n";index++;}}}
$('.category-user-list').html(userhtml);new SelectBox('category-caticon',{listclass:'no-default-icon',handlers:{change:this.categoryIconSelected.bind(this)}});new SelectBox('autoquery-qicon',{listclass:'no-default-icon',handlers:{change:this.autoQueryIconSelected.bind(this)}});new ItemList('category-users',{checkbox:true});}
else if(x!=null){}}
categoryIconSelected(value){$('#category-icon-preview').removeClass();$('#category-icon-preview').addClass('list-icon-'+value.replace('.png','').toLowerCase());}
autoQueryIconSelected(value){$('#autoquery-icon-preview').removeClass();$('#autoquery-icon-preview').addClass('list-icon-'+value.replace('.png','').toLowerCase());}
addNewCategory(options){var target=options;if(typeof options!="string"&&typeof options.param!="undefined")
target=options.param;if(target==undefined)
target=this.current_control_tab;this._addNewCategory(target);}
_addNewCategory(target){if(target=="categories"){$('#category-add-submit').addClass('event-createCategory');$('#category-add-submit').removeClass('event-editCategorySubmit');SelectBox.getSelectBox('category-caticon').set('folder-gray.png');$('#category-icon-preview').removeClass();$('#category-icon-preview').addClass('list-icon-folder-gray');$('.categoryusers').hide();new PopupPanel("category-add",{labels:{'category-edit-header':'Add New Category'},values:{'category-name':''},handlers:{enterkey:[['category-name','category-add-submit']]}});}
else{$('#autoquery-add-submit').addClass('event-createAutoquery');$('#autoquery-add-submit').removeClass('event-editAutoquerySubmit');SelectBox.getSelectBox('autoquery-qicon').set('gear.png');$('#autoquery-icon-preview').removeClass();$('#autoquery-icon-preview').addClass('list-icon-gear');new PopupPanel("autoquery-add",{labels:{'autoquery-edit-header':'Add New Auto-query'},values:{'autoquery-name':''},handlers:{enterkey:[['autoquery-name','autoquery-add-submit']]}});}}
deleteCategory(options){var target=options;if(typeof options!="string"&&typeof options.param!="undefined")
target=options.param;if(target==this.current_control_tab){var rowid=(target=="categories")?this.current_category_id:this.current_autoquery_id;this._deleteCategory(target,rowid);}
else{PopupPanel.showInformation({title:'Nothing Selected!',information:'Please select a '+(target=='categories'?"category":"autoquery")+' to delete first',message:''});}}
_deleteCategory(target,rowid){if(target=="categories"){var title='Delete Category';var c01=this.getCategory(rowid);if(typeof c01!="undefined"&&rowid>1){var msg='<p>This will delete the category <b>'+c01.name+'.</b></p>';if(parseInt(c01.dcount)>0){msg+='<p>Deleting this category will not remove the <b>'+c01.dcount+'</b> domains '+'that belong to it, however the categorization information (for example, "which were the domains '+'that used to belong to the category <b>'+c01.name+'"</b>) will be lost.</p>';}
else{msg+='<p>Currently there are no domains that belong to this category.</p>';}
var data=['category',c01.cid];}
else if(rowid==1)
var msg="The 'All Domains' is not a category and it cannot be deleted.";else
var msg="Please select a category first.";}
else if(target=="queries"){var c01=this.getAutoquery(rowid);var title='Delete Auto-query';if(typeof c01!="undefined"&&rowid>1){var msg='<p>This will delete the auto-query <b>\''+c01.name+'\'</b>.</p>'+'<p>Deleting an auto-query will not affect any of the domains.</p>';var data=['autoquery',c01.id];}
else if(rowid==1)
var msg="The 'All Domains' is not an auto-query and it cannot be deleted.";else
var msg="Please select an auto-query first.";}
if(typeof msg=="undefined")
msg="Please select a "+target+" to delete from the list first."
if(typeof data!="undefined"){PopupPanel.confirmAction({title:title,information:msg,message:'Are You Sure?',data:data,onyes:this.categoryDeleteConfirmed.bind(this)});}
else{PopupPanel.showInformation({title:title,information:msg,message:''});}}
categoryDeleteConfirmed(adata){if(adata[0]=='category'){var datastr=SEDAPI.construct("grid","category","del");datastr+="&id="+adata[1];SEDAPI.call(datastr,this.apiCategoryOrQueryDeleted.bind(this),adata[0]);}
else if(adata[0]=='autoquery'){var datastr=SEDAPI.construct("grid","query","del");datastr+="&id="+adata[1];SEDAPI.call(datastr,this.apiCategoryOrQueryDeleted.bind(this),adata[0]);}}
apiCategoryOrQueryDeleted(x,jqXHR,textStatus,params){if(x!=null&&x.status=='ok'){let mode=(params=='category')?1:2;this.getCategoriesList(mode);}
else if(x!=null)
this.showError(x.error);}
showError(msg){PopupPanel.showInformation({title:'Error',information:msg,message:''});}
createCategory(){var catname=$('#category-name').val();var caticon=$('#category-caticon').val();if(catname!=''&&caticon!=''){var datastr=SEDAPI.construct("grid","category","add");datastr+="&name="+encodeURIComponent(catname);datastr+="&caticon="+encodeURIComponent(caticon);SEDAPI.call(datastr,this.apiCategoryAddedOrEdited.bind(this),null);}
else{$('#category-add-status').html('Please fill-in the required information.');}}
apiCategoryAddedOrEdited(x,jqXHR,textStatus,params){if(x!=null&&x.status=='ok'){this.getCategoriesList(1);PopupPanel.hidePanel("category-add");}
else if(x){if(x.error=="nothing changed")
PopupPanel.hidePanel("category-add");else{$('#category-add-status').html(x.error);params=null;}}
if(params!=null&&params.users!=undefined&&params.catid!=undefined){this.saveUsersForCategory(params.catid,params.users);}}
saveUsersForCategory(cid,uids){var datastr=SEDAPI.construct("set","category","info");datastr+="&id="+parseInt(cid);datastr+="&uids="+encodeURIComponent(uids.join(","));SEDAPI.call(datastr,this.apiSavedUserIdsForCategory.bind(this),[cid,uids]);}
apiSavedUserIdsForCategory(x,jqXHR,textStatus,params){if(x!=null&&x.status=='ok'){this.category_users[params[0]]=params[1];}
else if(x){}}
editCategorySubmit(){var catname=$('#category-name').val();var caticon=$('#category-caticon').val();var catid=$('#category-id').val();if(catname!=''&&caticon!=''){var datastr=SEDAPI.construct("grid","category","edit");datastr+="&name="+encodeURIComponent(catname);datastr+="&caticon="+encodeURIComponent(caticon);datastr+="&id="+parseInt(catid);var userlist=ItemList.getItemList('category-users').getSelectionIds();SEDAPI.call(datastr,this.apiCategoryAddedOrEdited.bind(this),{users:userlist,catid:catid});}
else{$('#category-add-status').html('Please fill-in the required information.');}}
editCategory(options){var target=options;if(typeof options!="string"&&typeof options.param!="undefined")
target=options.param;if(target==this.current_control_tab){var rowid=(target=="categories")?this.current_category_id:this.current_autoquery_id;this._editCategory(target,rowid);}
else{PopupPanel.showInformation({title:'Nothing Selected!',information:'Please select a '+(target=='categories'?"category":"autoquery")+' to edit first',message:''});}}
_editCategory(target,rowid){if(target=="categories"&&rowid>1){var c01=this.getCategory(rowid);if(typeof c01!="undefined"){$('#category-icon-preview').removeClass();$('#category-icon-preview').addClass('list-icon-'+c01.caticon.replace(".png",''));SelectBox.getSelectBox('category-caticon').set(c01.caticon);var il=ItemList.getItemList('category-users');if(il)
il.setSelectionIds(this.category_users[c01.cid]);$('#category-add-submit').removeClass('event-createCategory');$('#category-add-submit').addClass('event-editCategorySubmit');$('.categoryusers').show();new PopupPanel("category-add",{labels:{'category-edit-header':'Edit Category'},values:{'category-name':c01.name,'category-caticon':c01.caticon,'category-id':c01.cid}});}
else
PopupPanel.showPopup('Please select a category from the list first');}
else if(rowid>1){var c01=this.getAutoquery(rowid);if(typeof c01!="undefined"){$('#autoquery-icon-preview').removeClass();$('#autoquery-icon-preview').addClass('list-icon-'+c01.qicon.replace(".png",''));SelectBox.getSelectBox('autoquery-qicon').set(c01.qicon);$('#autoquery-add-submit').removeClass('event-createAutoquery');$('#autoquery-add-submit').addClass('event-editAutoquerySubmit');new PopupPanel("autoquery-add",{labels:{'autoquery-edit-header':'Edit Auto-query'},values:{'autoquery-name':c01.name,'autoquery-query':c01.query,'autoquery-param':c01.params,'autoquery-qicon':c01.qicon,'autoquery-id':c01.id}});}
else
PopupPanel.showPopup('Nothing selected. Please select an auto-query to edit');}}
createAutoquery(){var aqname=$('#autoquery-name').val();var aqicon=$('#autoquery-qicon').val();var aqquery=$('#autoquery-query').val();var aqparam=$('#autoquery-param').val();if(aqname!=''&&aqicon!=''){var datastr=SEDAPI.construct("grid","query","add");datastr+="&name="+encodeURIComponent(aqname);datastr+="&qicon="+encodeURIComponent(aqicon);datastr+="&query="+encodeURIComponent(aqquery);datastr+="&params="+encodeURIComponent(aqparam);SEDAPI.call(datastr,this.apiAutoqueryAddedOrEdited.bind(this),null);}
else{$('#autoquery-add-status').html('Please fill-in the required information.');}}
apiAutoqueryAddedOrEdited(x,jqXHR,textStatus,params){if(x!=null&&x.status=='ok'){this.getCategoriesList(2);PopupPanel.hidePanel("autoquery-add");}
else if(x){$('#autoquery-add-status').html(x.error);}}
editAutoquerySubmit(){var aqname=$('#autoquery-name').val();var aqicon=$('#autoquery-qicon').val();var aqquery=$('#autoquery-query').val();var aqparam=$('#autoquery-param').val();var aqid=$('#autoquery-id').val();if(aqname!=''&&aqicon!=''){var datastr=SEDAPI.construct("grid","query","edit");datastr+="&id="+parseInt(aqid);datastr+="&name="+encodeURIComponent(aqname);datastr+="&qicon="+encodeURIComponent(aqicon);datastr+="&query="+encodeURIComponent(aqquery);datastr+="&params="+encodeURIComponent(aqparam);SEDAPI.call(datastr,this.apiAutoqueryAddedOrEdited.bind(this),null);}
else{$('#autoquery-add-status').html('Please fill-in the required information.');}}
helpAutoquery(){}
helpCategory(){var url='guide&key=kb-categories';AppModules.openLink(url,BRWIN_HELP);}
runQueryBuilder(){new PopupPanel('querybuilder',{});}
categoryOptionMenuSelected(value){if(value=='save-sort-order'){this._categoryListSorted("categorylist");}
else{saveCookie(COOKIE_CATEGORY_LIST_SORT,value);this.options.categories.sort=value;this.getCategoriesList(1);}}
autoQueryOptionMenuSelected(value){if(value=='save-sort-order'){this._categoryListSorted("querylist");}
else{saveCookie(COOKIE_AUTOQUERY_LIST_SORT,value);this.options.autoqueries.sort=value;this.getCategoriesList(2);}}
setupCategory(options){let user_access_rights=parseInt(user_details['rights']);if(options.param=='categories'){var selectid='categorysetup';var onchange=this.categoryOptionMenuSelected.bind(this);var items=[{value:'sortindex-asc',label:'Custom Sort',class:'list-popmenu-separator'},{value:'name-asc',label:'Sort Alpha Ascending'},{value:'name-desc',label:'Sort Alpha Descending',class:'list-popmenu-separator'},{value:'dcount-asc',label:'Sort Ascending Count'},{value:'dcount-desc',label:'Sort Descending Count',class:'list-popmenu-separator'},{value:'caticon-asc',label:'Sort Icons Ascending'},{value:'caticon-desc',label:'Sort Icons Descending',class:'list-popmenu-separator'}];if(bit_test(user_access_rights,ALLOW_CATEDIT_BITPOS))
items.push({value:'save-sort-order',label:'Save as Custom Sort',class:'list-popmenu-select-item-save require-catedit-rights'});var active=this.options.categories.sort;}
else{var selectid='autoquerysetup';var onchange=this.autoQueryOptionMenuSelected.bind(this);var items=[{value:'sortindex-asc',label:'Custom Sort',class:'list-popmenu-separator'},{value:'name-asc',label:'Sort Alpha Ascending'},{value:'name-desc',label:'Sort Alpha Descending',class:'list-popmenu-separator'},{value:'qicon-asc',label:'Sort Icons Ascending'},{value:'qicon-desc',label:'Sort Icons Descending',class:'list-popmenu-separator'}];if(bit_test(user_access_rights,ALLOW_AQUERY_BITPOS))
items.push({value:'save-sort-order',label:'Save as Custom Sort',class:'list-popmenu-select-item-save require-catedit-rights'});var active=this.options.autoqueries.sort;}
var offset=$(options.event.target).offset();var sb=new SelectBox(selectid,{change:onchange,popmenu:true,bottom:offset.top-5,left:offset.left,width:250,menu:items,parent:'control'});sb.set(active);options.event.preventDefault();options.event.stopPropagation();}}
class CustomColumnSetup{constructor(options={}){if(!CustomColumnSetup._instance){this.init(options);CustomColumnSetup._instance=this;}
return CustomColumnSetup._instance;}
init(options){this.options=options;new UserInput().eventHandler('#panel-customcolumns',this);new SelectBox('field_type');new SelectBox('field_index');var instance=this;$("#panel-customcolumns").on('change input','#field_name',(function(){instance.fieldNameChanged();}));}
show(){new PopupPanel("panel-customcolumns");this.showStatus('');this.initCustomColumns();}
showStatus(msg){PopupPanel.showStatus('customcolumns-error',msg);}
initCustomColumns(){var datastr=SEDAPI.construct("list","domain","columns");SEDAPI.call(datastr,this.apiSetupColumns.bind(this),null);}
refreshColumnList(columns){var list=this.getColumnList(columns);$('#customcolumns-columns').html(list);new ItemList('customcolumns-columns',{click:this.columnClicked.bind(this)});$('#field_name').val('');$('#field_name').focus();this.fieldNameChanged();}
apiSetupColumns(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){this.refreshColumnList(x.columns);this.showStatus('');}
else{this.showStatus(x.error);}}}
columnClicked(clickdata){var id=clickdata.item;$('#field_name').val(id);this.fieldNameChanged();}
getColumnList(columns){this.default_domain_columns=[];this.custom_domain_columns=[];this.domain_column_labels=[];this.domain_data_columns=columns;for(var key in columns){if(key==='length'||!columns.hasOwnProperty(key))continue;var label=columns[key]['label'];var ftype=columns[key]['fieldtype'];var gridview=parseInt(columns[key]['gridview']);var editable=parseInt(columns[key]['editable']);var custom=parseInt(columns[key]['custom']);if(!custom)
this.default_domain_columns.push(key);else
this.custom_domain_columns.push(key);this.domain_column_labels[key]=decodeURIComponent(label);}
return this.constructList(columns);}
constructList(columns){var list='';for(var i=0;i<this.custom_domain_columns.length;i++){var key=this.custom_domain_columns[i];var fieldclass='column-type-'+columns[key]['fieldtype']+"-custom";list+='<li id="'+key+'">'+"<div class=\"datatable-column-selector\"><div class=\""+fieldclass+"\"></div><div>"+key+"</div></div></li>";}
for(var i=0;i<this.default_domain_columns.length;i++){var key=this.default_domain_columns[i];var fieldclass='column-type-'+columns[key]['fieldtype'];list+='<li id="'+key+'">'+"<div class=\"datatable-column-selector\"><div class=\""+fieldclass+"\"></div><div>"+key+"</div></div></li>";}
return list;}
fieldNameChanged(){var fname=$('#field_name').val().trim();if(jQuery.inArray(fname.toLowerCase(),this.default_domain_columns)!=-1||fname==""){this.customFieldEditor(false);$("#customcolumns-remove").hide();$("#customcolumns-wipe").hide();$("#customcolumns-submit").hide();}
else{$("#customcolumns-remove").hide();$("#customcolumns-wipe").hide();if(jQuery.inArray(fname.toLowerCase(),this.custom_domain_columns)!=-1){$("#customcolumns-remove").show();$("#customcolumns-wipe").show();$("#customcolumns-submit").hide();this.customFieldEditor(false);}
else{$("#customcolumns-submit").show();this.customFieldEditor(true);}}
if(this.domain_data_columns.hasOwnProperty(fname)){var columninfo=this.domain_data_columns[fname];console.log(columninfo);SelectBox.getSelectBox('field_type').set(columninfo.fieldtype);SelectBox.getSelectBox('field_index').set("unknown");$("#field_default").val('');$("#field_index").val('');$("#field_width").val('');}}
customFieldEditor(status){if(!status){$("#field_type").attr("disabled",true);$("#field_width").attr("disabled",true);$("#field_default").attr("disabled",true);$("#field_index").attr("disabled",true);$(".custom-secondary").addClass("disabled",true);}
else{$("#field_type").attr("disabled",false);$("#field_width").attr("disabled",false);$("#field_default").attr("disabled",false);$("#field_index").attr("disabled",false);$(".custom-secondary").removeClass("disabled");}}
addNewCustomColumn(){this.showStatus('please wait');var datastr=SEDAPI.construct("admin","custom","add");datastr+="&name="+encodeURIComponent($('#field_name').val());datastr+="&type="+encodeURIComponent(SelectBox.getSelectBox('field_type').get());datastr+="&width="+encodeURIComponent($('#field_width').val());datastr+="&default="+encodeURIComponent($('#field_default').val());datastr+="&index="+encodeURIComponent(SelectBox.getSelectBox('field_index').get());datastr+="&columns=true";SEDAPI.call(datastr,this.apiCustomColumnChanged.bind(this),null);}
deleteCustomColumn(cdata,wipeall=false){this.showStatus('please wait');var datastr=SEDAPI.construct("admin","custom","del");datastr+="&name="+encodeURIComponent(cdata);datastr+="&columns=true";if(wipeall)
datastr+="&clear=true";SEDAPI.call(datastr,this.apiCustomColumnChanged.bind(this),null);}
wipeCustomColumnConfirmed(cdata){this.deleteCustomColumn(cdata,true);}
removeCustomColumnConfirmed(cdata){this.deleteCustomColumn(cdata,false);}
apiCustomColumnChanged(x,jqXHR,textStatus,params){console.log(x);if(x!=null){if(x.status=='ok'){this.refreshColumnList(x.columns);this.showStatus('ok');}}
else
this.showStatus(x.error);}
wipeCustomColumn(){var column=$('#field_name').val();if(column&&column.length){PopupPanel.confirmAction({title:"Remove &amp; Wipe Custom Column Data",information:'About to delete the custom column '+'<i>'+column+'</i> and delete all the data associated with it.',message:'Are You Sure?',data:column,onyes:this.wipeCustomColumnConfirmed.bind(this)});}}
removeCustomColumn(){var column=$('#field_name').val();if(column&&column.length){PopupPanel.confirmAction({title:"Remove Custom Column",information:'About to delete the custom column '+'<i>'+column+'</i>',message:'Are You Sure?',data:column,onyes:this.removeCustomColumnConfirmed.bind(this)});}}}
class DomainAdderPopup{constructor(options={}){if(!DomainAdderPopup._instance){this.init(options);DomainAdderPopup._instance=this;}
$("#csv-import-results").html('');$("#csv-import-notes").show();return DomainAdderPopup._instance;}
init(options){this.options=options;new SelectBox('csv_sep');new ItemList('csv-options',{checkbox:true});var ob=new ItemList('adddomains-options',{checkbox:true});var options=getCookie(COOKIE_ADD_DOMAIN_OPTIONS,"");if(options)
ob.setSelectionIds(options.split(','));this.tabs=new TabView('adp-tab',{change:function(current){}});var instance=this;$('#adddomains-submit').off('click');$('#adddomains-submit').click(function(event){instance.addDomains();});$('#adddomains-reset').off('click');$('#adddomains-reset').click(function(event){instance.resetDomains();});$('#panel-adddomains').on('change','.btn-file :file',function(){var filename=$('#csv_file').val();filename=filename.replace(/^.*[\\\/]/,'');$('#csv_name').val(filename);});}
show(){this.initAddDomains();new PopupPanel("panel-adddomains");this.showStatus('');}
initAddDomains(){var categoryName="";var cid=getCookieInt(COOKIE_CURRENT_CATEGORY_ID,1);if(cid>1){var rowData=this.options.panels.controls.getCategory(cid);categoryName="&quot;<b>"+rowData['name']+"</b>&quot;"
$("#adddomains-options").find(`[data-id='catadd']`).show();$("#adddomains-options").find(`[data-id='catempty']`).show();}
else{$("#adddomains-options").find(`[data-id='catadd']`).hide();$("#adddomains-options").find(`[data-id='catempty']`).hide();}
$(".adc-catname").html(categoryName);var datastr=SEDAPI.construct("admin","regapi","list");SEDAPI.call(datastr,this.apiGotRegistrarAPIList.bind(this),null);return false;}
showStatus(msg){PopupPanel.showStatus('adddomains-error',msg);}
resetDomains(){$('#domaindatatext').val('');$('#appendtlds').val('');}
addDomains(){var user_entry_data=$('#domaindatatext').val();var tlds=$('#appendtlds').val();var catid=this.options.panels.controls.current_category_id;var options=ItemList.getItemList('adddomains-options').getSelectionIds();if(!options.includes('catadd'))
catid=0;var emptycat=options.includes('catempty')?"1":"0";var bgproc=options.includes('add-bgprocess')?"1":"0";this.add_domains(user_entry_data,tlds,catid,emptycat,bgproc);var ob=ItemList.getItemList('adddomains-options');var options=ob.getSelectionIds();saveCookie(COOKIE_ADD_DOMAIN_OPTIONS,options.join(','));}
add_domains(domaindata,tlds,catid,emptycat,bgproc){this.showStatus('please wait');var addmode=this.tabs.settings.options.current;var datastr=SEDAPI.construct("add","domain","");if(addmode=="adp-manadd"){datastr+="&data="+encodeURIComponent(domaindata)+"&cid="+catid+'&emptycat='+emptycat;datastr+="&tlds="+encodeURIComponent(tlds?tlds:"");SEDAPI.call(datastr,this.apiAddDomains.bind(this),null);}
else if(addmode=="adp-regapi"){var options=ItemList.getItemList('regapichecklist').getSelectionIds();var checkedIds=options.map(function(id){return id.replace("regapi-","");});var ids=checkedIds.join(",");datastr+="&regapi="+encodeURIComponent(ids)+"&cid="+catid+'&emptycat='+emptycat;datastr+="&bgproc="+bgproc;SEDAPI.call(datastr,this.apiAddDomains.bind(this),null);}
else if(addmode=="adp-csv"){this.submitCSVImport(catid,emptycat);}}
apiAddDomains(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){if(x.added>0){this.showStatus('OK');}
else{if(x.category>1){}
this.showStatus(x.error);}
this.reloadTable();}
else
this.showStatus(x.error);}}
reloadTable(){this.options.panels.controls.getCategoriesList(1);if(this.options.panels.details){var dt=this.options.panels.details.domaintable;if(dt){dt.reload();if(dt.last_highlighted_rowid)
this.options.panels.details.showDomain(dt.last_highlighted_rowid);}}
if(this.options.panels.cards){this.options.panels.cards.show();this.options.panels.showAlert('');}}
apiGotRegistrarAPIList(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){var count=x.profiles.length;var listhtml="";for(var i=0;i<count;i++){var name=x.profiles[i];var pparams=x.data[name];listhtml+="<li data-index=\""+name+"\" id=\"regapi-"+name+"\">"+name+"</li>";}
$('#regapichecklist').html(listhtml);new ItemList('regapichecklist',{checkbox:true});if(!count)
$('#adp-regapi-status').html('No data sources configured. You can configure registrar APIs or data sources from the administration / settings module.');else
$('#adp-regapi-status').html('');}}}
submitCSVImport(cid,emptycat){this.showStatus('please wait');var fd=new FormData($('#csv-upload')[0]);fd.append('c',"add");fd.append('t',"domain");fd.append('oper',"csv");fd.append('cid',cid);fd.append('emptycat',emptycat);var sep=SelectBox.getSelectBox('csv_sep').get();var csvoptions=ItemList.getItemList('csv-options').getSelectionIds();var luq=csvoptions.includes('csv-luq')?"1":"0";var wp=csvoptions.includes('csv-writeprotect')?"1":"0";fd.append('csv-writeprotect',wp);fd.append('csv-luq',luq);fd.append('csv_sep',sep);for(var pair of fd.entries()){}
SEDAPI.formData(fd,this.apiCSVImportDone.bind(this),null);}
apiCSVImportDone(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){var colcount=x.columns.length;var columns="";var status='<ul class="list list-with-icons">';status+='<li class="list-group-item">File: '+x.data['file']+"</li>";status+='<li class="list-group-item">Type: '+x.data['type']+"</li>";status+='<li class="list-group-item">Size: '+x.data['size']+"Kb</li>";for(var i=0;i<colcount;i++){if(columns!="")
columns+=", ";columns+=x.columns[i];}
status+='<li class="list-group-item">'+colcount+" columns found ("+columns+")</li>";status+='<li class="list-group-item">'+x.added+" domains added </li>";status+='<li class="list-group-item">'+x.existing+" domains already in database</li>";status+="</ul>";this.reloadTable();$("#csv-import-results").html(status);$("#csv-import-notes").hide();this.showStatus('ok');}
else{this.showStatus(x.error);}}}}
class DomainDeleter{constructor(options={}){if(!DomainDeleter._instance){this.init(options);DomainDeleter._instance=this;}
return DomainDeleter._instance;}
init(options){this.options=options;}
show(safedelete=false){var dt=this.options.panels.details.domaintable;var sc=dt.getSelectedDomainCount();var catid=getCookieInt(COOKIE_CURRENT_CATEGORY_ID,0);var ids=dt.getSelectedIds();var info=safedelete?'This is a safer delete option that will delete only the domains that belong to the current category and no other. Any domain in the list that is also a member of another category will not be deleted.':'This will permanenetly delete the selected domains from the database and the corresponding categories. This canot be undone. Are you Sure?';var onyes=safedelete?this.safeDeleteDomainsConfirmed.bind(this):this.deleteDomainsConfirmed.bind(this);if(safedelete&&catid<=1){PopupPanel.showInformation({title:'Not available',information:"Safe delete option is available only when a category is selected and can't be used when displaying all the domains.",message:''});}
else if(sc){var msg="This will affect <i>"+dt.getAffectedDomainsText()+"</i>";PopupPanel.confirmAction({title:'Delete Domains',information:info,message:msg,data:{ids:ids,cid:catid},onyes:onyes});}
else{PopupPanel.showInformation({title:'Nothing to do!',information:"Please select the domains you want to delete.",message:''});}}
deleteDomainsConfirmed(data){var datastr=SEDAPI.construct("grid","domain","del");datastr+="&id="+encodeURIComponent(data.ids.join(","));SEDAPI.call(datastr,this.apiDomainsDeleted.bind(this),null);}
safeDeleteDomainsConfirmed(data){var datastr=SEDAPI.construct("del","domain","safe");datastr+="&id="+encodeURIComponent(data.ids)+"&cid="+data.cid;SEDAPI.call(datastr,this.apiDomainsDeleted.bind(this),null);}
apiDomainsDeleted(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){if(x.deleted>0){this.options.panels.controls.getCategoriesList(1);var dt=this.options.panels.details.domaintable;dt.reload();if(this.ids&&this.ids.includes(dt.last_highlighted_rowid))
this.options.panels.details.showDomain(dt.last_highlighted_rowid);}}}}}
class DomainDetails{constructor(options){this.options=options;this.current_domain_tab=getCookie(COOKIE_CURRENT_DOMAIN_TAB,'registry');this.current_selected_domain=getCookie(COOKIE_SELECTED_DOMAIN_NAME,'');this.domaintableheight=getCookieInt(COOKIE_DOMAIN_TABLE_HEIGHT,300);this.domain_data={};this.domain_info={};this.domain_cids={};this.domainfieldinfo={};var domainid=getCookieInt(COOKIE_SELECTED_DOMAIN_ID,0);this.initDNSTable(domainid);this.initSSLTable(domainid);if(domain_data_fields!=undefined&&domain_data_fields.length){var ddf=domain_data_fields.split(';');this.domainfields=ddf.length?ddf:undefined;}
var instance=this;new TabView('domaintabwrap',{change:function(current){instance.current_domain_tab=current;instance.showDomainTabHeading();instance.resizeApp();saveCookie(COOKIE_CURRENT_DOMAIN_TAB,current);},current:this.current_domain_tab});$('#dnsrecords').on('click keypress','.btn-del-sdrecord',function(e){var sid=$(this).attr("data-sid");var sd=$(this).attr("data-sd");event.preventDefault();var msg='This will delete the subdomain '+sd+' for '+instance.current_selected_domain;PopupPanel.confirmAction({title:'Delete Subdomain',information:msg,message:'Do you want to delete the record?',data:{subdomain:sd,sid:sid,domain:instance.current_selected_domain},onyes:instance.deleteSubdomain.bind(instance)});});$('#txtrecords').on('click keypress','.btn-del-txtrecord',function(e){var sid=$(this).attr("data-sid");var sd=$(this).attr("data-txt");event.preventDefault();var msg='This will delete the text record '+sd+' for '+instance.current_selected_domain;PopupPanel.confirmAction({title:'Delete TXT Record',information:msg,message:'Do you want to delete the record?',data:{txt:sd,sid:sid,domain:instance.current_selected_domain},onyes:instance.deleteTxtRecord.bind(instance)});});$('#data-toolbox').on('click keypress','.btn-tools',function(e){let cs=ItemList.a11yClick(e);if(cs>0){var url=$(this).data('url');if(instance.current_selected_domain!=""){url=url.replace("{{domain}}",instance.current_selected_domain);window.open(url,BRWIN_DOMAIN_TOOLS);}}});$('#domaintabwrap').on('click','.btn-inline-dfedit',function(e){if($(this).parent()&&$(this).parent().parent()&&$(this).parent().parent().children()&&$(this).parent().parent().children().length==3){var dfelem=$(this).parent().parent().children()[2];var column=$(dfelem).attr("data-key");var value=$(dfelem).attr("data-value");var sid=$(dfelem).attr("data-did");instance.domainfieldinfo={sid:sid,column:column};if($(dfelem).children()&&$(dfelem).children().length){var ib=$(dfelem).children()[0];var newvalue=$(ib).val();var alledited=[];$("#domainfields .edited-input").each(function(){var cv=$(this).val();var cc=$(this).parent().attr('data-key');alledited.push({key:cc,value:cv});});if(newvalue!=value)
alledited.push({key:column,value:newvalue});if(alledited.length){$(ib).addClass('edited-input');var datastr=SEDAPI.construct("grid","domain","edit");datastr+="&id="+sid;for(var i=0;i<alledited.length;i++)
datastr+="&"+encodeURIComponent(alledited[i].key)+"="+encodeURIComponent(alledited[i].value);SEDAPI.call(datastr,instance.apiDomainGridRowEdited.bind(instance),[sid,column,newvalue]);}
else
$(ib).removeClass('edited-input');}}});$('#domaintabwrap').on('change','.input-button-input',function(e){var parent=$(this).parent();if(parent){var column=$(parent).attr("data-key");var value=$(parent).attr("data-value");var sid=$(parent).attr("data-did");var newvalue=$(this).val();if(newvalue!=value)
$(this).addClass('edited-input');}});$("#domaintabwrap").on('keydown','.input-button-input',function(e){var keycode=(e.keyCode?e.keyCode:(e.which?e.which:e.charCode));if(keycode==13){var parent=$(this).parent();parent.children()[1].click();}
return true;});new View('domaindata',{mode:2,responsive_width:0,handlers:{resize:function(height){instance.sizeDomainDataPanel(height);}}});let ui=new UserInput();ui.eventHandler('#domain-row-edit',this);ui.eventHandler('#domainfields-records',this);ui.eventHandler('#domainfields',this);var ob=new ItemList('autocopy-table-cells',{checkbox:true,click:this.autocopyStatusChanged.bind(this)});this.domaintable=new DomainDataTable({handlers:{resize:this.resizeApp.bind(this),show:this.showDomain.bind(this),role:this.roleHandler.bind(this)}});this.showDomain(domainid);setInterval(function(){instance.showSessionQueueCount(domainid,false);},60000);$("#queue_refresh").click(function(e){instance.showSessionQueueCount(domainid,true);e.preventDefault();});this.initQueueButtons();}
autocopyStatusChanged(cdata){this.domaintable.setOption('tablecellcopy',cdata.value);}
addSubdomains(){if(this.options.handlers.actions){this.options.handlers.actions('subdomainadd');}}
addTXTRecords(){if(this.options.handlers.actions){this.options.handlers.actions('textrecordadd');}}
deleteSubdomain(sdata){var sid=sdata.sid;var subdomain=sdata.subdomain;var datastr=SEDAPI.construct("del","subdomain","");datastr+="&id="+encodeURIComponent(sid);datastr+="&subdomain="+encodeURIComponent(subdomain);SEDAPI.call(datastr,this.apiSDRecordDeleted.bind(this),null);}
deleteTxtRecord(sdata){var sid=sdata.sid;var txtrecord=sdata.txt;var datastr=SEDAPI.construct("del","txtrecord","");datastr+="&id="+encodeURIComponent(sid);datastr+="&subdomain="+encodeURIComponent(txtrecord);SEDAPI.call(datastr,this.apiSDRecordDeleted.bind(this),null);}
apiSDRecordDeleted(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){var dt=this.domaintable;this.showDomain(dt.last_highlighted_rowid);}}}
initDNSTable(domainid){let user_access_rights=parseInt(user_details['rights']);var delclass=bit_test(user_access_rights,ALLOW_DELETE_BITPOS)?'':'hidden';var addclass=bit_test(user_access_rights,ALLOW_ADD_BITPOS)?'':'hidden';var editclass=bit_test(user_access_rights,ALLOW_EDIT_BITPOS)?'':'hidden';var ddp=this;var source={type:'ajax',params:{url:SEDAPI.getURL(),data:'c=grid&t=dns',post:['sid']}};var footer=[{role:'separator'},{role:'add',class:addclass},{role:'edit',class:editclass},{role:'separator'},{role:'delete',class:delclass},{role:'separator'},{role:'refresh'},{role:'separator'},{role:'copy'},{role:'download'},{role:'separator'},{role:'setup',icon:'column-setup'}];var handlers={resize:ddp.resizeApp.bind(ddp),role:function(command){ddp.tableAction('dnstable',command);},colwidth:function(column,width){ddp.saveColumnWidth(column,width);},columns:function(cdata,set=true){if(set){ddp.saveColumns(cdata,'subdomaingrid_columns_array');}}};var dc=subdomaingrid_columns_array;dc=DataTableView.normalizeColumns(dc);var dt=new DataTableView('dnstable',{columns:dc,source:source,parent:'dnstablewrap',footer:footer,handlers:handlers,sort:'s.subdomain',sortorder:'desc',count:100,columnsort:true,sid:domainid,autosize:false,uidelay:grid_auto_search_delay?grid_auto_search_delay:600});}
saveColumnWidth(name,width){let user_access_rights=parseInt(user_details['rights'])
if(bit_test(user_access_rights,ALLOW_UICHANGE_BITPOS)){var datastr=SEDAPI.construct("admin","domain","set");datastr+="&width="+width+"&name="+encodeURIComponent(name);SEDAPI.call(datastr,SEDAPI.apiCallBack,null);}}
saveColumns(cdata,dgroup){let user_access_rights=parseInt(user_details['rights']);if(bit_test(user_access_rights,ALLOW_UICHANGE_BITPOS)){var colsetup="";for(var i=0;i<cdata.length;i++){if(cdata[i].name!="domain"&&cdata[i].name!="d.domain"&&cdata[i].name!="r_h_disp"&&cdata[i].name!="d.r_h_disp"&&cdata[i].name!="dt_ser_num"&&cdata[i].name!="cb"){if(colsetup!="")
colsetup+=";"+cdata[i].name;else
colsetup+=cdata[i].name;}}
var datastr=SEDAPI.construct("set","domain","colmodel");datastr+="&group="+encodeURIComponent(dgroup);datastr+="&columns="+encodeURIComponent(colsetup);SEDAPI.call(datastr,SEDAPI.apiCallBack,dgroup);}}
initSSLTable(domainid){let user_access_rights=parseInt(user_details['rights']);var delclass=bit_test(user_access_rights,ALLOW_DELETE_BITPOS)?'':'hidden';var addclass=bit_test(user_access_rights,ALLOW_ADD_BITPOS)?'':'hidden';var editclass=bit_test(user_access_rights,ALLOW_EDIT_BITPOS)?'':'hidden';var ddp=this;var source={type:'ajax',params:{url:SEDAPI.getURL(),data:'c=grid&t=ssl',post:['sid']}};var footer=[{role:'separator'},{role:'edit',class:editclass},{role:'separator'},{role:'delete',class:delclass},{role:'separator'},{role:'refresh'},{role:'separator'},{role:'copy'},{role:'download'},{role:'separator'},{role:'setup',icon:'column-setup'}];var handlers={resize:ddp.resizeApp.bind(ddp),role:function(command){ddp.tableAction('ssltable',command);},colwidth:function(column,width){ddp.saveColumnWidth(column,width);},columns:function(cdata,set=true){if(set){ddp.saveColumns(cdata,'sslgrid_columns_array');}}};var dc=sslgrid_columns_array;dc=DataTableView.normalizeColumns(dc);var dt=new DataTableView('ssltable',{columns:dc,source:source,parent:'ssltablewrap',footer:footer,handlers:handlers,sort:'s.subdomain',sortorder:'desc',count:100,columnsort:true,sid:domainid,autosize:false,uidelay:grid_auto_search_delay?grid_auto_search_delay:600});}
tableAction(tablename,command){var dt=DataTableView.getTable(tablename);if(command=='setup'){this.roleHandler(tablename+'setup');}
else{var domainid=getCookieInt(COOKIE_SELECTED_DOMAIN_ID,0);if(command=="add"&&tablename=="dnstable"){this.roleHandler('subdomainadd');}
else if(command=="delete"){if(tablename=="dnstable"){var dt=DataTableView.getTable('dnstable');var lookuptype="DNS"}
else if(tablename=="ssltable"){var dt=DataTableView.getTable('ssltable');var lookuptype="SSL"}
if(dt!==undefined){var hid=dt.last_highlighted_rowid;var subdomains=dt.getSelected('s.subdomain').slice(0,99999);var hids=dt.getSelectedIds().map(function(item){return parseInt(item,10);});var tabledata=dt.options.data;var rowcount=hids.length;if(rowcount){var msg='<p>This will delete '+rowcount+' '+lookuptype+' record row(s) for the domain ('+this.current_selected_domain+'). Even if you delete these rows, valid '+lookuptype+' records will get restored after a successful lookup is performed.</p><p>Use this option to purge old and invalid '+lookuptype+' records from the database.</p>';PopupPanel.confirmAction({title:'Delete '+lookuptype+' Row(s)',information:msg,message:'Do you want to delete the records?',data:{table:tablename,sid:domainid,hids:hids,domain:this.current_selected_domain},onyes:this.deleteSubdomainRowConfirmed.bind(this)});}}}
else if(command=="edit"){this.roleHandler(tablename=="dnstable"?"dnsedit":"ssledit");}}}
deleteSubdomainRowConfirmed(sdata){if(sdata.table=='ssltable'){var datastr=SEDAPI.construct('grid','ssl','del');}
else if(sdata.table=='dnstable'){var datastr=SEDAPI.construct('grid','dns','del');}
datastr+='&id='+encodeURIComponent(sdata.hids.join(','));SEDAPI.call(datastr,this.apiSubdomainRowsDeleted.bind(this),sdata.table);}
apiSubdomainRowsDeleted(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){var dt=DataTableView.getTable(params);if(dt){dt.reload();}}
else{}}}
sizeDomainDataPanel(height){var tbht=$('#domaintabwrap .tabview-buttons').outerHeight();var adht=parseInt($('#domaindata').css('padding-top').replace('px',''))-$('#apptoolbar').outerHeight(true);this.domaintableheight=height-(adht+3);saveCookie(COOKIE_DOMAIN_TABLE_HEIGHT,this.domaintableheight);this.resizeApp();}
resizeApp(){if(this.options.handlers!=undefined&&this.options.handlers.resize!=undefined)
this.options.handlers.resize();}
showDomainTabHeading(){if(this.current_domain_tab!="about")
$('#domain-details-heading').html(this.current_selected_domain==''?'No domain is currently selected':this.current_selected_domain);else
$('#domain-details-heading').html(product_name_string);}
showDomain(domainid){var datastr=SEDAPI.construct("get","domain","");datastr+="&id="+domainid;SEDAPI.call(datastr,this.showDomainDetails.bind(this),null);var dnstable=DataTableView.getTable('dnstable');if(dnstable){dnstable.setOption('sid',domainid);dnstable.reload();}
var ssltable=DataTableView.getTable('ssltable');if(ssltable){ssltable.setOption('sid',domainid);ssltable.reload();}
this.showSessionQueueCount(domainid);}
static cleanupWhoisText(text){if(text!==undefined){text=text.replaceAll("\n<br>","\n");text=text.replaceAll("\r<br>","\n");text=text.replaceAll("<br>","\n");text=text.replaceAll("&gt;",">");text=text.replaceAll("&lt;","<");}
else
text='';return text;}
registryWhoisPopup(options){var domain=$('#registry-whois-details').attr('data-domain');var sb=SelectBox.getSelectBox('registry-whois-details');if(sb){var hid=sb.get().replace("whid-","");var datastr=SEDAPI.construct("get","domain","history");datastr+="&id="+encodeURIComponent(hid);SEDAPI.call(datastr,this.apiGotDomainHistory.bind(this),{domain:domain,show:"registry",mode:'popup'});}}
registrarWhoisPopup(){var domain=$('#registry-whois-details').attr('data-domain');var sb=SelectBox.getSelectBox('registrar-whois-details');if(sb){var hid=sb.get().replace("whid-","");var datastr=SEDAPI.construct("get","domain","history");datastr+="&id="+encodeURIComponent(hid);SEDAPI.call(datastr,this.apiGotDomainHistory.bind(this),{domain:domain,show:"registrar",mode:'popup'});}}
apiGotDomainHistory(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){if(params.mode=="popup"){var whoistext=DomainDetails.cleanupWhoisText(x.history.tvalue);var newtext=DomainDetails.cleanupWhoisText(params.show=='registry'?this.current_registry_whois:this.current_registrar_whois);var textToShow=findTextDiff(whoistext,newtext);new PopupPanel("whois-popup-view",{labels:{'whois-popup-view-header':SelectBox.toTitleCase(params.show+' whois'),'whois-popup-view-subhead':params.domain+' @ '+x.history.lookedup_at,'whois-popup-text':textToShow,'whois-popup-highlight-msg':'Any data that is different from the latest recorded WHOIS/RDAP text will be shown highlighted.'}});}
else if(params.mode=="pane"){if(params.show=="registry"){var textToShow=x.history.tvalue;this.showWhoisText('registrydisplaytext',textToShow);}
else if(params.show=="registrar"){var textToShow=x.history.tvalue;this.showWhoisText('registrardisplaytext',textToShow);}}}}}
showWhoisText(divid,whoistext){if(this.isJson(whoistext)){$('#'+divid).html('<pre>'+whoistext+'</pre>');}
else{$('#'+divid).html(whoistext);}}
registryWhoisSelected(value){var hid=value.replace("whid-","");var datastr=SEDAPI.construct("get","domain","history");datastr+="&id="+encodeURIComponent(hid);SEDAPI.call(datastr,this.apiGotDomainHistory.bind(this),{show:"registry",mode:'pane'});}
registrarWhoisSelected(value){var hid=value.replace("whid-","");var datastr=SEDAPI.construct("get","domain","history");datastr+="&id="+encodeURIComponent(hid);SEDAPI.call(datastr,this.apiGotDomainHistory.bind(this),{show:"registrar",mode:'pane'});}
showDomainDetails(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){this.domain_data=x.data;this.domain_info=x.info;this.domain_cids=x.cids;this.current_selected_domain=x.data['domain'];var registrycontrols="<select data-domain=\""+x.data['domain']+"\" data-sid=\""+x.data['sid']+"\" id=\"registrywhoiscontrols\">";var registrarcontrols="<select data-domain=\""+x.data['domain']+"\" data-sid=\""+x.data['sid']+"\" id=\"registrarwhoiscontrols\">";var registrysel=null;var registrarsel=null;var historyhtml="";for(var i=0;i<x.history.length;i++){var h=x.history[i];var id=h['id'];var ldate=h['lookedup_at'].replace(".000000","");if(h['ftype']==256){registrarcontrols+="<option class=\"list-item-whois\" value=\"whid-"+id+"\">"+ldate+"</option>";registrarsel=registrarsel?registrarsel:"whid-"+id;}
else if(h['ftype']==1){registrycontrols+="<option class=\"list-item-whois\"  value=\"whid-"+id+"\">"+ldate+"</option>";registrysel=registrysel?registrysel:"whid-"+id;}}
registrycontrols+="</select>";registrarcontrols+="</select>";$('#registry-whois-select').html(registrycontrols);$('#registrar-whois-select').html(registrarcontrols);SelectBox.removeSelectBox('registrywhoiscontrols');var sb01=new SelectBox('registrywhoiscontrols',{handlers:{change:this.registryWhoisSelected.bind(this)}});sb01.set(registrysel);SelectBox.removeSelectBox('registrarwhoiscontrols');var sb02=new SelectBox('registrarwhoiscontrols',{handlers:{change:this.registrarWhoisSelected.bind(this)}});sb02.set(registrarsel);$("#ipwhois").html(x.data.ip_whois);var registrywhois,registrarwhois;if(this.isJson(x.data.registry_whois))
registrywhois="<div id=\"registrydisplaytext\"><pre>"+x.data.registry_whois+"</pre></div>";else{registrywhois="<div id=\"registrydisplaytext\"><pre>"+x.data.registry_whois.replaceAll('<br>',"\n")+"</pre></div>";}
if(this.isJson(x.data.registrar_whois))
registrarwhois="<div id=\"registrardisplaytext\"><pre>"+x.data.registrar_whois+"</pre></div>";else{registrarwhois="<div id=\"registrardisplaytext\"><pre>"+x.data.registrar_whois.replaceAll('<br>',"\n")+"</pre></div>";}
$("#registry > .whois").html(registrywhois);$("#registrar > .whois").html(registrarwhois);this.current_registry_whois=x.data.registry_whois;this.current_registrar_whois=x.data.registrar_whois;this.showDomainTabHeading();var luqinfo="";var lc=x.luq.length;for(var i=0;i<lc;i++){luqinfo+="<li class=\"\">"+x.luq[i]['label']+" | "+x.luq[i]['created_on']+" | "+x.luq[i]['server']+"</li>\n";}
if(!lc)
luqinfo+="<li class=\"\">No lookup queue entries found for domain "+x.data['domain']+"</li>";$("#domainluqdata").html(luqinfo);this.showDomainInfo(x);saveCookie(COOKIE_SELECTED_DOMAIN_NAME,this.current_selected_domain);if(this.options.handlers!=undefined&&this.options.handlers.drawCategoryList!=undefined)
this.options.handlers.drawCategoryList();var url=SEDAPI.getURL()+"?c=get&t=webshot&domain="+x.data['domain'];$('#webshotthumb').attr("src",url);}
else{this.current_selected_domain="";$('#registry-whois-select').html('');$('#registrar-whois-select').html('');$('#registry-whois-list').html('-');$('#registrar-whois-list').html('-');this.showDomainTabHeading();$("#registry > .whois").html('');$("#registrar > .whois").html('');$("#ipwhois").html('');$("#domainfields").html('');$('#dnsrecords').html('');$('#txtrecords').html('');}}}
showDomainInfo(x){var user_access_rights=parseInt(user_details['rights']);var details="";var added=[];if(this.domainfields!=undefined&&this.domainfields.length){for(var i=0;i<this.domainfields.length;i++){added.push(this.domainfields[i]);details+=this.getDomainFieldsDiv(x,this.domainfields[i]);}}
for(var key in x.data){if(added.includes(key))continue;details+=this.getDomainFieldsDiv(x,key);}
this.showSubdomains(x);this.showTXTRecords(x);var registrysel=null;var registrarsel=null;var registrywhois="<select data-domain=\""+x.data['domain']+"\" data-sid=\""+x.data['sid']+"\" id=\"registry-whois-details\">";var registrarwhois="<select data-domain=\""+x.data['domain']+"\" data-sid=\""+x.data['sid']+"\" id=\"registrar-whois-details\">";for(var i=0;i<x.history.length;i++){var h=x.history[i];var id=h['id'];var ldate=h['lookedup_at'].replace(".000000","");ldate=DomainDetails.dateTimeToDateHoursMinutes(ldate);var ft="1";if(h['ftype']==256){registrarwhois+="<option class=\"list-item-whois\" value=\"whid-"+id+"\">"+ldate+"</option>";registrarsel=registrarsel?registrarsel:"whid-"+id;}
else if(h['ftype']==1){registrywhois+="<option class=\"list-item-whois\"  value=\"whid-"+id+"\">"+ldate+"</option>";registrysel=registrysel?registrysel:"whid-"+id;}}
registrywhois+="</select>";registrarwhois+="</select>";var regpopup='<div><div class="dficon"><div class="datafield column-type-text"></div></div><div>Registry Whois</div><div class="whois-list"><div id="registry-whois-list"></div><div class="btn btn-tb-view icon-24 event event-registryWhoisPopup"></div></div></div>';regpopup+='<div><div class="dficon"><div class="datafield column-type-text"></div></div><div>Registrar Whois</div><div class="whois-list"><div id="registrar-whois-list"></div><div class="btn btn-tb-view icon-24 event event-registrarWhoisPopup"></div></div></div>';$("#domainfields").html(regpopup+details);$('#registry-whois-list').html(registrywhois);SelectBox.removeSelectBox('registry-whois-details');var sb01=new SelectBox('registry-whois-details');sb01.set(registrysel);$('#registrar-whois-list').html(registrarwhois);SelectBox.removeSelectBox('registrar-whois-details');var sb02=new SelectBox('registrar-whois-details');sb02.set(registrarsel);var dd=this;$('#domainfields').sortable({handle:'.dficon',items:'.dfsortable',stop:function(event,ui){var clist=[];$('#domainfields').find('.dfrow').each(function(i,el){clist.push($(this).attr('data-key'));});dd.domainfields=clist;var datastr=SEDAPI.construct("set","domain","datafields");datastr+="&fields="+encodeURIComponent(clist.join(";"));SEDAPI.call(datastr,SEDAPI.apiCallBack,undefined);},start:function(){},containment:'parent',});var domainid=getCookieInt(COOKIE_SELECTED_DOMAIN_ID,0);if(this.domainfieldinfo.hasOwnProperty('sid')&&this.domainfieldinfo['sid']==domainid){var column=this.domainfieldinfo['column'];if(column!=undefined){var elem=$("#domainfields").find(`[data-key='${column}']`);if(elem!=undefined){var inp=$(elem).find('.input-button-input');this.domainfieldinfo={};var strLength=inp.val().length*2;inp.focus();inp[0].setSelectionRange(strLength,strLength);}}}}
getDomainFieldsDiv(x,key){if(key==='length'||!x.data.hasOwnProperty(key))return;let user_access_rights=parseInt(user_details['rights']);var edit_rights=bit_test(user_access_rights,ALLOW_EDIT_BITPOS);var details='';var did=x.data['sid'];var value=x.data[key];var label=x.info[key]['label'];var ftype=x.info[key]['fieldtype'];var gridview=parseInt(x.info[key]['gridview']);var editable=parseInt(x.info[key]['editable']);var custom=parseInt(x.info[key]['custom']);var imgclass="datafield column-type-"+ftype+(custom?"-custom":"");if(editable==1&&edit_rights){var iv=(typeof value==='string')?value.replaceAll('"','&quot;'):value;var inputfield='<input type="text" value="'+iv+'" class="input-button-input" placeholder=""><div class="input-button-item btn-inline-dfedit btn-default btn-with-image" id=""></div>';}
var icon="<div class=\""+imgclass+"\"></div>";if(gridview==1&&key!="r_h_disp"){if(key!="domain"&&key!="tld")
details+="<div class=\"dfsortable\">";else
details+="<div>";details+="<div class=\"dficon\">"+icon+"</div>";details+='<div>'+label+"</div>";var inpf=(typeof inputfield!="undefined")?inputfield:value;details+="<div class=\"input-button dfrow\" data-did=\""+did+"\" data-value=\""+value+"\" data-key=\""+key+"\">"+inpf+"</div>";details+="</div>\n";}
return details;}
showTXTRecords(x){var user_access_rights=parseInt(user_details['rights']);var txtrecords="";var sid=x.data['sid'];if(x.txtrecords.length){for(var i=0;i<x.txtrecords.length;i++){var sdlink="<li><div>";sdlink+=x.txtrecords[i];sdlink+="</div><div class=\"btn-delete btn-del-txtrecord\" data-sid=\""+sid+"\" data-txt=\""+x.txtrecords[i]+"\"></div></li>";txtrecords+=sdlink;}}
if(bit_test(user_access_rights,ALLOW_ADD_BITPOS)){}
$('#txtrecords').html(txtrecords);}
showSubdomains(x){var user_access_rights=parseInt(user_details['rights']);var subdomains="";var sid=x.data['sid'];if(x.subdomains.length){for(var i=0;i<x.subdomains.length;i++){var sdlink="<li><div>";sdlink+=x.subdomains[i];sdlink+="</div><div class=\"btn-delete btn-del-sdrecord\" data-sid=\""+sid+"\" data-sd=\""+x.subdomains[i]+"\"></div></li>";subdomains+=sdlink;}}
if(bit_test(user_access_rights,ALLOW_ADD_BITPOS)){}
$('#dnsrecords').html(subdomains);}
apiDomainGridRowEdited(x,jqXHR,textStatus,params){if(x!=null&&x.status=='ok'){this.domaintable.selectRow(params[0]);this.domaintable.reload();}}
domainRowEdit(){var column=$('#domain-row-edit-domain-column').val();var sid=$('#domain-row-edit-domain-id').val();var value=$('#domain-row-edit-column-value').val();var datastr=SEDAPI.construct("grid","domain","edit");datastr+="&id="+sid;datastr+="&"+column+"="+encodeURIComponent(value);SEDAPI.call(datastr,this.apiDomainGridRowEdited.bind(this),[sid,column,value]);PopupPanel.hidePanel("domain-row-edit");}
showSessionQueueCount(domainid=0,swipein=false){var datastr=SEDAPI.construct("get","luq","");datastr+="&id="+domainid;if(!swipein)
datastr+="&sw=false";SEDAPI.call(datastr,this.apiGotLUQData.bind(this),null);}
apiGotLUQData(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){this.setLUQData(x);}}}
setLUQData(x){if(x.server_time&&x.last_seen_at){try{var t01=Date.parse(x.last_seen_at)/ 1000;var t02=Date.parse(x.server_time)/ 1000;var seconds=t02-t01;var days=Math.floor(seconds /(24*60*60));seconds-=days*(24*60*60);var hours=Math.floor(seconds /(60*60));seconds-=hours*(60*60);var minutes=Math.floor(seconds /(60));seconds-=minutes*(60);var cs=[];if(days)
cs.push(days+(days>1?" days":" day"));if(hours)
cs.push(hours+(hours>1?" hours":" hour"));if(minutes&&!hours&&!days)
cs.push(minutes+" min");if(!hours&&!days)
cs.push(seconds+' seconds');cs=cs.join(", ")+' ago';if(days||hours||minutes>2){$('#luq_cron_status').addClass('error');$('#luq_cron_status').css('text-align','left');$('#cron_not_running').addClass('error');$('#cron_not_running').html('Your cron job either not set or not working!');}
else{$('#luq_cron_status').removeClass('error');$('#cron_not_running').removeClass('error');$('#cron_not_running').html('');}
$('#luq_cron_status').html(cs);}
catch(err){}}
$("#qs-all").html(x.queue_size);$("#queue_server_time").html(x.server_time);$("#server_time").html(x.server_time);$("#queue_last_connect").html(x.last_seen_at);$("#queue_last_lookup").html(x.last_lookup_at);$("#qs-dw").html(x.dw_size);$("#qs-sdw").html(x.sdw_size);$("#qs-ipw").html(x.ipw_size);$("#qs-alexa").html(x.alexa_size);$("#qs-ip").html(x.ip_size);$("#qs-dns").html(x.dns_size);$("#qs-gi").html(x.gi_size);$("#qs-ping").html(x.ping_size);$("#qs-http").html(x.http_size);$("#qs-ssl").html(x.ssl_size);$("#timeout").html(x.timeout);$("#server_time_zone").html(x.server_time_zone);$("#luqw-dw").attr('disabled',(x.dw_size>0)?false:true);$("#luqw-sdw").attr('disabled',(x.sdw_size>0)?false:true);$("#luqw-ssl").attr('disabled',(x.ssl_size>0)?false:true);$("#luqw-ip").attr('disabled',(x.ip_size>0)?false:true);$("#luqw-ipw").attr('disabled',(x.ipw_size>0)?false:true);$("#luqw-gi").attr('disabled',(x.gi_size>0)?false:true);$("#luqw-ping").attr('disabled',(x.ping_size>0)?false:true);$("#luqw-http").attr('disabled',(x.http_size>0)?false:true);$("#luqw-alexa").attr('disabled',(x.alexa_size>0)?false:true);$("#luqw-dns").attr('disabled',(x.dns_size>0)?false:true);}
initQueueButtons(){var instance=this;$('.btn-luq-wipe').click(function(event){event.preventDefault();var cpid=$(this).attr('id');if(cpid.substr(0,5)=="luqw-"){var luqtype=cpid.replace("luqw-","");instance.deleteLookupQueue(luqtype);}});$('.btn-luq-trigger').click(function(event){event.preventDefault();var cpid=$(this).attr('id');if(cpid.substr(0,5)=="luqa-"){var luqtype=cpid.replace("luqa-","");instance.doLookups(luqtype);}});}
deleteLookupQueue(luqtype){PopupPanel.confirmAction({title:'Lookup Queue',information:'This will wipe the current lookup queue. The lookup scheduler will automatically queue these domains again unless you have disabled automatic lookups.',message:'Are You Sure?',data:{type:luqtype},onyes:this.deleteLUQConfirmed.bind(this)});}
deleteLUQConfirmed(adata){var luqtype=adata.type;var datastr=SEDAPI.construct("set","luq","del");datastr+="&type="+encodeURIComponent(luqtype);SEDAPI.call(datastr,this.apiDeleteLUQCompleted.bind(this),null);}
apiDeleteLUQCompleted(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){this.showSessionQueueCount(0,true);}}}
doLookups(luqtype){var datastr=SEDAPI.construct("set","luq","schedule");var refreshinterval=parseInt($('#qb-refresh-interval').val());if(refreshinterval==0){refreshinterval=1;datastr+="&riu=1";}
datastr+="&ri="+encodeURIComponent(refreshinterval);datastr+="&limit="+encodeURIComponent($('#qb-domain-limit').val());datastr+="&type="+encodeURIComponent(luqtype);SEDAPI.call(datastr,this.apiDoLookupDone.bind(this),null);}
apiDoLookupDone(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){this.showSessionQueueCount(0,true);}}}
roleHandler(command){if(this.options.handlers.actions){this.options.handlers.actions(command);}}
isJson(str){if(typeof str!=='string')
return false;try{JSON.parse(str);}
catch(e){return false;}
return true;}
static dateTimeToDateHoursMinutes(datev){try{var d=new Date(Date.parse(datev.replace(/-/g,"/")));return d.getFullYear()+"-"+String(d.getMonth()+1).padStart(2,"0")+"-"+String(d.getDate()).padStart(2,"0")+" "+String(d.getHours()).padStart(2,"0")+":"+String(d.getMinutes()).padStart(2,"0");}
catch(err){console.log('DateTime Error: '+datev+': '+err);return'';}}}
class DomainPopupPanels{constructor(domaincontrols,domaindetails,options={}){this.controls=domaincontrols;this.details=domaindetails;this.init();}
init(){let ui=new UserInput();ui.eventHandler('#appsidebar',this);ui.eventHandler('.domain-data-panels',this);ui.eventHandler('#about',this);}
supportOptionsSelected(value){AppModules.openLink(value,BRWIN_HELP);}
buttonClicked(options){AppModules.openLink(options.param,BRWIN_HELP);}
resetLicense(){PopupPanel.confirmAction({title:'License Reset',information:'Are you sure you want to reset your license? You will not be able to access the application unless you provide a new valid license code.',message:'',data:null,onyes:this.resetLicenseConfirmed.bind(this)});}
resetLicenseConfirmed(){var datastr=SEDAPI.construct("admin","license","set");datastr+="&data="+encodeURIComponent("-");SEDAPI.call(datastr,this.apiResetLicense.bind(this),null);}
apiResetLicense(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){AppModules.open();}}}
showSupportOptions(options){var selectid='supportoptions';var onchange=this.supportOptionsSelected.bind(this);var items=[{value:'guide',label:'User Guide...'},{value:'changelog',label:'Check For Updates...'},{value:'home',label:'Product Home Page...'},{value:'contact',label:'Contact Us...'}];var offset=$(event.target).offset();var sb=new SelectBox(selectid,{change:onchange,popmenu:true,bottom:offset.top+32,left:offset.left-265-10,width:250,menu:items,parent:'contentwrap'});$(".sbi-"+selectid+'-list-item').removeClass('active');options.event.preventDefault();options.event.stopPropagation();}
addDomains(){new DomainAdderPopup({panels:this}).show();}
deleteDomains(){new DomainDeleter({panels:this}).show();}
safeDeleteDomains(){new DomainDeleter({panels:this}).show(true);}
addSubdomains(defmode="sd"){var domainid=getCookieInt(COOKIE_SELECTED_DOMAIN_ID,0);if(domainid>0)
new SubdomainAdder({panels:this}).show(domainid,this.details.current_selected_domain,defmode);}
setupDNSTable(){new SubdomainColumnSetup({panels:this}).show('dns');}
setupSSLTable(){new SubdomainColumnSetup({panels:this}).show('ssl');}
editDNSData(){new BulkEdit({panels:this}).show('dns');}
editSSLData(){new BulkEdit({panels:this}).show('ssl');}
parseDomains(){new ParseDomains({panels:this}).show();}
setRegistrarAlias(){new RegistrarAlias({panels:this}).show();}
lookupDomains(){new DomainLookupPopup({panels:this}).show();}
bulkEditDomains(){new BulkEdit({panels:this}).show();}
editSelectedColumnsForDomains(columns){new BulkEdit({panels:this}).show("domain",columns);}
addDomainCustomColumns(){new CustomColumnSetup({panels:this}).show();}
downloadDomainData(){new DomainTableDownload({panels:this}).show();}
setupDomainTableColumns(){new ColumnSetup({panels:this}).show();}
setupWhois(){new WhoisSetup({panels:this}).show();}
categorizeomains(){new CategorizeDomains({panels:this}).show();}
processLookupQueue(){new ProcessQueue({panels:this}).show();}
setupUI(){new UserInterface().show();}}
class DomainDataTable extends DataTableView{static get(){return DomainDataTable.getTable('domaintable');}
static setHeight(ht){if(DomainDataTable.get())
DomainDataTable.get().setHeight(ht);}
constructor(options){let user_access_rights=parseInt(user_details['rights']);var delclass=bit_test(user_access_rights,ALLOW_DELETE_BITPOS)?'':'hidden';var addclass=bit_test(user_access_rights,ALLOW_ADD_BITPOS)?'':'hidden';var editclass=bit_test(user_access_rights,ALLOW_EDIT_BITPOS)?'':'hidden';var dnloadclass=bit_test(user_access_rights,ALLOW_DOWNLOAD_BITPOS)?'':'hidden';let ehighlight=getCookieInt(COOKIE_EXPIRY_HIGLIGHT_DAYS,30);if(ehighlight<30||ehighlight>90)
ehighlight=30;var source={type:'ajax',params:{url:SEDAPI.getURL(),data:'c=grid&t=domain&highlight='+ehighlight,post:['cid','aqid']}};var footer=[{role:'separator'},{role:'add',class:addclass},{role:'edit',class:editclass},{role:'separator'},{role:'delete',class:delclass},{role:'separator'},{role:'refresh'},{role:'separator'},{role:'safe-delete',class:delclass},{role:'separator'},{role:'copy',class:dnloadclass},{role:'download',class:dnloadclass},{role:'separator'},{role:'setup',icon:'column-setup'},{role:'separator'},{role:'clearfilters'}];var handlers={resize:function(){options.handlers.resize();},colwidth:function(column,width){if(DomainDataTable.get())
DomainDataTable.get().saveColumnWidth(column,width);},columns:function(cdata,set=true){if(set){if(DomainDataTable.get())
DomainDataTable.get().saveColumns(cdata);}},select:function(rowid){saveCookie(COOKIE_SELECTED_DOMAIN_ID,rowid);options.handlers.show(rowid);},ajaxData:function(tdata){if(tdata&&typeof tdata.total!="undefined"&&tdata.total>=0){if(DomainDataTable.get())
DomainDataTable.get().scrollSelectionIntoView();}
var dt=DomainDataTable.get();if(dt){saveCookie(COOKIE_DOMAIN_SORT_COLUMN,dt.options.sort+":"+dt.options.sortorder);}},columnclick:function(cdata){$('#table_cell_copy').val(cdata.value);let dt=DomainDataTable.get();if(dt){if((dt.options.tablecellcopy!==undefined&&dt.options.tablecellcopy===true)){DataTableView._clipboardCopy(cdata.value);}}},role:function(command){if(options.handlers.role)
options.handlers.role(command);}};var dg=getCookie(COOKIE_CURRENT_DISPLAY_GROUP,'date');var controltab=getCookie(COOKIE_CATEGORY_CONTROL_TAB,'categories');var cid=(controltab=="categories")?getCookieInt(COOKIE_CURRENT_CATEGORY_ID,1):0;var aqid=(controltab=="categories")?0:getCookieInt(COOKIE_CURRENT_AUTOQUERY_ID,1);var dc=DomainDataTable.normalizeColumns(window[dg+'_columns_array']);var sorts=getCookie(COOKIE_DOMAIN_SORT_COLUMN,'tld:asc').split(":");var sort=typeof sorts[0]!=="undefined"?sorts[0]:"d.tld";var sortorder=typeof sorts[1]!=="undefined"?sorts[1]:"asc";super('domaintable',{columns:dc,source:source,parent:'domaintablewrap',footer:footer,handlers:handlers,sort:sort,sortorder:sortorder,count:getCookieInt(COOKIE_ITEMS_PER_PAGE,250),selection:getCookieInt(COOKIE_SELECTED_DOMAIN_ID,0),nodatamsg:"No domains found. Please add some domains",cid:cid,aqid:aqid,columnsort:true,heading:'',autosize:false,uidelay:grid_auto_search_delay?grid_auto_search_delay:600});this.registrar_aliases=registrar_aliases;}
scrollSelectionIntoView(){var dt=DomainDataTable.get();var current_domainid=getCookieInt(COOKIE_SELECTED_DOMAIN_ID,0);if(dt&&current_domainid>0)
dt.scrollIntoView(current_domainid);}
saveColumnWidth(name,width){let user_access_rights=parseInt(user_details['rights'])
if(bit_test(user_access_rights,ALLOW_UICHANGE_BITPOS)){var datastr=SEDAPI.construct("admin","domain","set");datastr+="&width="+width+"&name="+encodeURIComponent(name);SEDAPI.call(datastr,SEDAPI.apiCallBack,null);}}
registrarFormatter(cellvalue){if(cellvalue==null)
return"";if(typeof this.registrar_aliases!='undefined'){if(cellvalue.toLowerCase()in this.registrar_aliases)
return this.registrar_aliases[cellvalue.toLowerCase()];}
return cellvalue;}
highlightFormatter(cellvalue){if(cellvalue==15&&cellvalue!=null)
return'<img title="Nearing expiry" class="dt-icon-alert" src="lib/layouts/images/icons/alerts/24/alert-yellow.png" alt="'+cellvalue+'">';else if(cellvalue==17&&cellvalue!=null)
return'<img title="Past expiry" class="dt-icon-alert"  src="lib/layouts/images/icons/alerts/24/alert-red.png" alt="'+cellvalue+'">';else if(cellvalue==20&&cellvalue!=null)
return'<img title="Name server discrepancy" class="dt-icon-alert"  src="lib/layouts/images/icons/alerts/24/tri-alert-orange.png" alt="'+cellvalue+'">';else if(cellvalue==18&&cellvalue!=null)
return'<img title="Domain status alert" class="dt-icon-alert" src="lib/layouts/images/icons/alerts/24/tri-alert-red.png" alt="'+cellvalue+'">';else if(cellvalue==16&&cellvalue!=null)
return'<img title="Nearing or past expiry" class="dt-icon-alert" src="lib/layouts/images/icons/alerts/24/alert-red.png" alt="'+cellvalue+'">';else if(cellvalue==14&&cellvalue!=null)
return'<img title="Unknown expiry date" class="dt-icon-alert" src="lib/layouts/images/icons/alerts/24/unknown-blue.png" alt="'+cellvalue+'">';else if(cellvalue==13&&cellvalue!=null)
return'<img title="No recent whois" class="dt-icon-alert" src="lib/layouts/images/icons/alerts/24/search-alert.png" alt="'+cellvalue+'">';else if(cellvalue==12&&cellvalue!=null)
return'<img title="Available domain" class="dt-icon-alert" src="lib/layouts/images/icons/alerts/24/ok.png" alt="'+cellvalue+'">';else if(cellvalue==11&&cellvalue!=null)
return'<img title="Requires whois search token setup" class="dt-icon-alert" src="lib/layouts/images/icons/alerts/24/tri-alert-yellow.png" alt="'+cellvalue+'">';else if(cellvalue==10&&cellvalue!=null)
return'<img title="Manually edited" class="dt-icon-alert" src="lib/layouts/images/icons/alerts/24/pencil.png" alt="'+cellvalue+'">';else if(cellvalue==19&&cellvalue!=null)
return'<img title="Write Protected" class="dt-icon-alert" src="lib/layouts/images/icons/alerts/24/lock.png" alt="'+cellvalue+'">';else if(cellvalue==null)
return'<img class="dt-icon-alert" src="lib/layouts/images/icons/alerts/24/question.png" alt="'+cellvalue+'">';else
return'<img class="dt-icon-alert" src="lib/layouts/images/icons/alerts/24/empty.png" alt="'+cellvalue+'">';}
saveColumns(cdata){let user_access_rights=parseInt(user_details['rights']);if(bit_test(user_access_rights,ALLOW_UICHANGE_BITPOS)){var dgroup=getCookie(COOKIE_CURRENT_DISPLAY_GROUP,'date')+"_columns_array";var colsetup="";for(var i=0;i<cdata.length;i++){if(cdata[i].name!="domain"&&cdata[i].name!="d.domain"&&cdata[i].name!="r_h_disp"&&cdata[i].name!="d.r_h_disp"&&cdata[i].name!="dt_ser_num"&&cdata[i].name!="cb"){if(colsetup!="")
colsetup+=";"+cdata[i].name;else
colsetup+=cdata[i].name;}}
var datastr=SEDAPI.construct("set","domain","colmodel");datastr+="&group="+encodeURIComponent(dgroup);datastr+="&columns="+encodeURIComponent(colsetup);SEDAPI.call(datastr,SEDAPI.apiCallBack,dgroup);}}
getSelectedDomains(maxcount=999999){return this.getSelected('d.domain').slice(0,maxcount);}
getSelectedDomainCount(){return $('.tcb-'+this.options.table+':checkbox:checked').length;}
getAffectedDomainsText(maxcount=10){var msg=this.getSelectedDomains(maxcount).join(", ");var tc=this.getSelectedDomainCount();if(tc>maxcount){msg+=" and "+(tc-maxcount)+" more domains.";}
return msg;}}
const SELECTED_GRID_ROWS=1;const ALL_GRID_ROWS=2;const ALL_DBTABLE_ROWS=3;class DomainTableDownload{constructor(options={}){if(!DomainTableDownload._instance){this.init(options);DomainTableDownload._instance=this;}
return DomainTableDownload._instance;}
init(options){this.options=options;new SelectBox('select_csv_report');new SelectBox('column-type');new SelectBox('row-type',{change:this.rowTypeChanged.bind(this)});new SelectBox('download_delimiter');let ui=new UserInput();ui.eventHandler('#panel-download',this);}
show(){new PopupPanel("panel-download");this.refreshDownloadList();var dt=this.options.panels.details.domaintable;this.ids=dt.getSelectedIds();$('.affected-domains').html(dt.getAffectedDomainsText());this.rowTypeChanged();}
refreshDownloadList(){var datastr=SEDAPI.construct("download","csvdata","get");SEDAPI.call(datastr,this.apiInitDownload.bind(this),null);}
showStatus(msg){PopupPanel.showStatus('download-error',msg);}
apiInitDownload(x,jqXHR,textStatus,params){if(x!=null){this.showStatus('');var cbdata='';if(x.status=='ok'){var count=x.data.length;for(var i=0;i<count;i++){var name=x.data[i].name;var id=parseInt(x.data[i].id);var desc=x.data[i].description;if(desc!="")
desc=" ["+desc+"]";if(id>0){cbdata+='<option value="'+id+'">'+name+desc+'</option>';}}
$('#select_csv_report').html(cbdata);}
else{this.showStatus(x.error);$('#select_csv_report').html(cbdata);}
new SelectBox('select_csv_report');}}
downloadScheduledReport(){this.showStatus('');var rid=SelectBox.getSelectBox('select_csv_report').get();if(parseInt(rid)>0){var datastr=SEDAPI.construct("download","csvdata","get");datastr+="&id="+encodeURIComponent(rid);datastr+="&mode=csv"
var posturl=app_root_url+api_url_path+"?";$("#csvdownload").append('<form id="exportform" action="'+posturl+datastr+'" method="post"></form>');$("#exportform").submit().remove();}
return true;}
deleteScheduledReport(){var rid=SelectBox.getSelectBox('select_csv_report').get();var reportname=$("#select_csv_report option:selected").text();PopupPanel.confirmAction({title:"Delete Report",information:"About to delete a domain data report \""+reportname+"\"",message:'Are You Sure?',data:rid,onyes:this.deleteDomainReportConfirmed.bind(this)});}
deleteDomainReportConfirmed(rid){if(parseInt(rid)>0){var datastr=SEDAPI.construct("download","csvdata","del");datastr+="&id="+encodeURIComponent(rid);SEDAPI.call(datastr,this.apiInitDownload.bind(this),null);}}
rowTypeChanged(){var rowtype=parseInt(SelectBox.getSelectBox('row-type').get());this.showStatus('');}
scheduleDownload(){this._downloadDomainData(true);}
downloadDomainData(){this._downloadDomainData(false);}
_downloadDomainData(bgproc){var rowtype=parseInt(SelectBox.getSelectBox('row-type').get());var coltype=SelectBox.getSelectBox('column-type').get();var filename=$('#download_file_name').val();var delimiter=parseInt(SelectBox.getSelectBox('download_delimiter').get());this.downloadDomainTableRows("domaintable",rowtype,coltype,filename,delimiter,bgproc);}
downloadDomainTableRows(gridid,rowtype,colmode,filename,delimiter,bgproc){$('#download-error').html('');bgproc=bgproc?"1":"0";var sids="";if(rowtype==SELECTED_GRID_ROWS){var rowids=[];sids=this.ids;for(var i=0;i<sids.length;i++){var s=parseInt(sids[i]);rowids.push(s);}
sids=rowids.join(",");}
var tablecolumns=[];var dt=this.options.panels.details.domaintable;var columns=dt.getOptions().columns;for(i=0;i<columns.length;i++){if(columns[i].name!="dt_ser_num"&&columns[i].name!="rn"&&columns[i].name!="cb"&&columns[i].name!="r_h_disp"&&columns[i].name!="s.r_h_disp"&&columns[i].name!="d.r_h_disp"&&columns[i].name!="subgrid"){tablecolumns.push(columns[i].name);}}
columns=tablecolumns.join(",");var description="";if(rowtype==SELECTED_GRID_ROWS)
description+=" Selected Rows";else if(rowtype==ALL_GRID_ROWS)
description+=" Grid Rows";else if(rowtype==ALL_DBTABLE_ROWS)
description+=" All Rows";if(colmode=="domain")
description+=" & Domain Names";else if(colmode=="grid")
description+=" & Grid Columns";else if(colmode=="all")
description+=" & All Columns";var posturl=SEDAPI.getURL()+"?";var datastr=SEDAPI.construct("download","domain","");datastr+="&id="+encodeURIComponent(sids);datastr+="&columns="+encodeURIComponent(columns);datastr+="&colmode="+encodeURIComponent(colmode);datastr+="&csv_sep="+encodeURIComponent(delimiter);datastr+="&description="+encodeURIComponent(description);if(rowtype==ALL_GRID_ROWS){var aqid=this.options.panels.controls.current_autoquery_id;var cid=this.options.panels.controls.current_category_id;if(cid>0)
datastr+="&cid="+cid;else if(aqid>0)
datastr+="&aqid="+aqid;}
if(rowtype==SELECTED_GRID_ROWS&&sids==""){$('#download-error').html('Nothing to download');return false;}
var sortname=dt.options.sort;var sortorder=dt.options.sortorder;datastr+="&sidx="+encodeURIComponent(sortname);datastr+="&sord="+encodeURIComponent(sortorder);datastr+="&filename="+encodeURIComponent(filename);if(parseInt(bgproc)){datastr+="&bgproc="+encodeURIComponent(bgproc);SEDAPI.call(datastr,this.apiDownloadCSVData.bind(this),null);}
else{$("#csvdownload").append('<form id="exportform" action="'+posturl+datastr+'" method="post"></form>');$("#exportform").submit().remove();return true;}}
apiDownloadCSVData(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){}
this.showStatus(x.error);}}}
$(function(){$('[title]').tooltip();var dp=new DomainDataPanel();initTouch();$('.btn-tb-data').hide();setTimeout(function(){dp.showDomainTableHeading();$('body').show();dp.resizeApp();},250);});class DomainDataPanel{constructor(){this.current_display_group=getCookie(COOKIE_CURRENT_DISPLAY_GROUP,'date');this.showActiveDisplayGroupButton();$('#menuselect').click(function(e){if(!$('#control').is(':visible')){$('#control').show();$('.menu-select').css('background-image','url(lib/layouts/colors/light/images/64/cancel.png)');}
else{$('#control').hide();$('.menu-select').css('background-image','url(lib/layouts/colors/light/images/64/menu.png)');}});var thisobj=this;$(window).on('resize',function(){thisobj.resizeApp();});let ui=new UserInput();ui.eventHandler('#apptoolbar',this);ui.eventHandler('#control',this);this.controls=new ControlsPane({handlers:{resize:this.resizeApp.bind(this),change:this.categoryChange.bind(this),drawCategoryList:this.drawCategoryList.bind(this),dataInit:this.controlsDataReceived.bind(this)}});this.details=new DomainDetails({handlers:{resize:this.resizeApp.bind(this),drawCategoryList:this.drawCategoryList.bind(this),actions:this.userActions.bind(this)}});this.panels=new DomainPopupPanels(this.controls,this.details,{});}
controlsDataReceived(datainfo){if(!this.heading&&datainfo==this.controls.current_control_tab){this.showDomainTableHeading();this.heading=true;}}
userActions(command){if(command=='add')
this.panels.addDomains();else if(command=='delete')
this.panels.deleteDomains();else if(command=="safe-delete")
this.panels.safeDeleteDomains();else if(command=="setup")
this.panels.setupDomainTableColumns();else if(command=='edit'){var columns=[];var tcolumns=this.details.domaintable.options.columns;for(var i=0;i<tcolumns.length;i++){var c=tcolumns[i].name.replace('d.','');if(c!=='dt_ser_num'&&c!='cb'&&c!='r_h_disp'&&c!='domain')
columns.push(c);}
this.panels.editSelectedColumnsForDomains(columns);}
else if(command=='subdomainadd')
this.panels.addSubdomains();else if(command=='textrecordadd')
this.panels.addSubdomains('txt');else if(command=='dnstablesetup')
this.panels.setupDNSTable();else if(command=='ssltablesetup')
this.panels.setupSSLTable();else if(command=='dnsedit')
this.panels.editDNSData();else if(command=='ssledit')
this.panels.editSSLData();}
drawCategoryList(){var cids=(this.details.domain_cids!=undefined&&this.details.domain_cids.length)?this.details.domain_cids:['0'];if(this.controls!=undefined)
this.controls.drawCategoryList(cids);}
showDomainTableHeading(){var heading='';var icon='';if(this.controls.current_control_tab=="categories"&&this.controls.categories){var cc=this.controls.getCategory();if(cc!=undefined){heading=cc.name;icon=cc.cid==1?"folder-all-domains":cc.caticon;}}
else if(this.controls.autoqueries){var cc=this.controls.getAutoquery();if(cc!=undefined){heading=cc.name;icon=cc.id==1?"folder-all-queries":cc.qicon;}}
icon='list-icon-'+icon.replace('.png','');this.details.domaintable.setHeading(heading,icon);}
categoryChange(cselection){var id=cselection.id;var tab=cselection.tab;var dt=DomainDataTable.get();if(dt){if(tab=="categories"){dt.setOption('aqid',0);dt.setOption('cid',id);}
else{dt.setOption('aqid',id);dt.setOption('cid',0);}
dt.reload();}
this.showDomainTableHeading();}
resizeApp(){var width=$('#content').width();var height=$('#content').height();var logoht=$('#biglogo').outerHeight(true);var cht=$('#control').height();var lht=cht-logoht-$('#categories .controlfooter').outerHeight(true)-$('#controltab .tabview-buttons').outerHeight(true);$('#categorylist').css('max-height',lht);lht=cht-logoht-$('#queries .controlfooter').outerHeight(true)-$('#controltab .tabview-buttons').outerHeight(true);$('#querylist').css('max-height',lht);var ww=$(window).width();if(ww>=768&&!$('#control').is(':visible')){$('#control').show();$('.menu-select').css('background-image','url(lib/layouts/colors/'+ColorMode.getMode()+'/images/64/menu.png)');}
else if(ww<768&&$('#control').is(':visible')){$('#control').hide();$('.menu-select').css('background-image','url(lib/layouts/colors/'+ColorMode.getMode()+'/images/64/menu.png)');}
var dtht=0;if(this.details!=undefined&&this.details.domaintable!=undefined){if(this.details.domaintableheight>(height-300))
this.details.domaintableheight=(height<480)?height/2:height-300;this.details.domaintable.setHeight(this.details.domaintableheight);dtht=this.details.domaintableheight;}
height=$('#domaindata').height();var hsheight=$('#domaintablesplit').outerHeight(true);var tbht=$('#domaintabwrap .tabview-buttons').outerHeight(true);var thht=$('#domaintabwrap .tabview-heading').outerHeight(true);var ddheight=height-hsheight-dtht-tbht-thht;$('#domaintabwrap .tabview-panel').css('height',ddheight);if(DataTableView.getTable('dnstable'))
DataTableView.getTable('dnstable').setHeight(ddheight-2);if(DataTableView.getTable('ssltable'))
DataTableView.getTable('ssltable').setHeight(ddheight-2);$('.popup-body').css('max-height',$(window).height()*0.8-$('.popup-header').outerHeight()-$('.popup-footer').outerHeight());$('.popup-body').css('overflow','auto');}
showActiveDisplayGroupButton(group=''){group=(group==''?this.current_display_group:group);$('#apptoolbar').find('.btn').removeClass('active');$('#apptoolbar').find('.event-'+group+'-openDomainDataTable').addClass('active');}
openModule(options){AppModules.open(options.param);}
openDomainDataTable(options){var group=options;if(typeof options!="string"&&typeof options.param!="undefined")
group=options.param;var columns=window[group+'_columns_array'];this.details.domaintable.setColumns(columns);this.current_display_group=group;saveCookie(COOKIE_CURRENT_DISPLAY_GROUP,group);this.showActiveDisplayGroupButton();this.showDomainTableHeading();}}
class DomainLookupPopup{constructor(options={}){if(!DomainLookupPopup._instance){this.init(options);DomainLookupPopup._instance=this;}
return DomainLookupPopup._instance;}
init(options){this.options=options;new ItemList('lookup-selection',{checkbox:true});let ui=new UserInput();ui.eventHandler('#panel-lookup',this);}
show(){var dt=this.options.panels.details.domaintable;var sc=dt.getSelectedDomainCount();if(sc){new PopupPanel("panel-lookup");var msg="This will affect <i>"+dt.getAffectedDomainsText()+"</i>";$('#lookup-domains').html(msg);}
else
PopupPanel.showPopup('Please select the domains you want to lookup','Nothing to do!');}
showStatus(msg){PopupPanel.showStatus('lookup-error',msg);}
doLookups(){var luw=0;var ilb=ItemList.getItemList('lookup-selection');var luts=ilb.getSelectionIds();var lui={luwhois:DOMAIN_RECORDS,ludns:ROOT_DNS,luhttp:HTTP_WEBSITE,lualexa:ALEXA_DATA,luping:PING_RESPONSE,luipwhois:IP_WHOIS,lugindex:GOOGLE_INDEX,lusubdom:SUB_DOMAINS,lussl:SSL_CERTS};for(var key in lui){if(lui.hasOwnProperty(key)&&luts.includes(key))
luw|=lui[key];}
var luint=$("#luint").val();if(luint=="")
luint=1440;this.showStatus('');if(luw!=0){if(luint<0)
luint=1440;var dt=this.options.panels.details.domaintable;var ids=dt.getSelectedIds();var datastr=SEDAPI.construct("set","luq","");datastr+="&what="+luw+"&id="+ids+"&ri="+luint;SEDAPI.call(datastr,this.apiLUQAddDone.bind(this),null);}
else
$('#lookup-error').html('Nothing to do!');}
apiLUQAddDone(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){if(x.status=='ok'&&x.count>0)
PopupPanel.hidePanel("panel-lookup");else if(x.status=='ok'&&x.count==0)
this.showStatus("Nothing queued. The domain may already be in queue or write protected, otherwise change the minimum refresh interval to force.");else
this.showStatus(x.msg);var domainid=getCookieInt(COOKIE_SELECTED_DOMAIN_ID,0);this.options.panels.details.showDomain(domainid);}
else
this.showStatus(x.error);}}}
class ParseDomains{constructor(options={}){if(!ParseDomains._instance){this.init(options);ParseDomains._instance=this;}
return ParseDomains._instance;}
init(options){this.options=options;new UserInput().eventHandler('#panel-parse',this);}
show(){var dt=this.options.panels.details.domaintable;var sc=dt.getSelectedDomainCount();if(sc){new PopupPanel("panel-parse");this.showStatus('');this.ids=dt.getSelectedIds();$('.affected-domains').html(dt.getAffectedDomainsText());}
else
PopupPanel.showPopup("Please select the domains to parse","No Domains Selected");}
showStatus(msg){PopupPanel.showStatus('parsedomains-error',msg);}
parseDomains(){var datastr=SEDAPI.construct("set","domain","parse");datastr+="&id="+encodeURIComponent(this.ids.join(','));SEDAPI.call(datastr,this.apiParse.bind(this),null);}
apiParse(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){var dt=this.options.panels.details.domaintable;dt.reload();if(this.ids.includes(dt.last_highlighted_rowid))
this.options.panels.details.showDomain(dt.last_highlighted_rowid);PopupPanel.hidePanel("panel-parse");}
else{this.showStatus(x.error);}}}}
class ProcessQueue{constructor(options={}){if(!ProcessQueue._instance){this.init(options);ProcessQueue._instance=this;}
return ProcessQueue._instance;}
init(options){this.options=options;new UserInput().eventHandler('#panel-processqueue',this);this.processing=0;}
show(){new PopupPanel("panel-processqueue");this.showStatus('');}
showStatus(msg){PopupPanel.showStatus('processqueue-error',msg);}
submitProcessQueue(){if(!this.processing){this.processing++;var datastr=SEDAPI.construct("set","luq","process");this.showStatus("please wait");SEDAPI.call(datastr,this.apiQueueProcessed.bind(this),null);}
else{this.showStatus("Busy");}}
apiQueueProcessed(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){var qstatus='';qstatus+="<li class=\"list-group-item\">Attempted: "+x.attempted+"</li>";qstatus+="<li class=\"list-group-item\">Processed: "+x.processed+"</li>";qstatus+="<li class=\"list-group-item\">Time: "+x.time+"</li>";$('#processqueue-status').html(qstatus);if(x.processed){var dt=this.options.panels.details.domaintable;if(dt){this.ids=dt.getSelectedIds();dt.reload();if(this.ids.includes(dt.last_highlighted_rowid))
this.options.panels.details.showDomain(dt.last_highlighted_rowid);}}
this.showStatus("ok");}}
this.processing--;}}
class RegistrarAlias{constructor(options={}){if(!RegistrarAlias._instance){this.init(options);RegistrarAlias._instance=this;}
return RegistrarAlias._instance;}
init(options){let ui=new UserInput();ui.eventHandler('#panel-regalias',this);this.options=options;}
show(){var dt=this.options.panels.details.domaintable;var sc=dt.getSelectedDomainCount();var ids=dt.getSelectedIds().join(',');$('#alias').val("");if(sc>0){var datastr=SEDAPI.construct("get","domain","column");datastr+="&columns=registrar&id="+encodeURIComponent(ids);SEDAPI.call(datastr,this.apiGotDomainColumnData.bind(this),null);}}
apiGotDomainColumnData(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){var rows=x.data.length;var registrar='';var sameregistrar=true;for(var i=0;i<rows;i++){if(i==0)
registrar=x.data[i]['registrar'];else if(registrar!=x.data[i]['registrar']){sameregistrar=false;break;}}
if(sameregistrar){$('#alias').val(registrar);$('#regalias-registrar-label').html(registrar);$('#regalias-registrar').val(registrar);var dt=this.options.panels.details.domaintable;if(typeof dt.registrar_aliases!='undefined'){if(registrar.toLowerCase()in dt.registrar_aliases)
$('#alias').val(dt.registrar_aliases[registrar.toLowerCase()]);}
new PopupPanel("panel-regalias");}
else{PopupPanel.showInformation({title:'Registrar Alias',information:"Please select only a single domain or select domains that have the same registrar",message:''});}}}}
regaliasSubmit(){var alias=$('#alias').val();var registrar=$('#regalias-registrar').val();var params=[registrar,alias];var datastr=SEDAPI.construct("set","regalias","column");datastr+="&name="+encodeURIComponent(registrar)+"&alias="+encodeURIComponent(alias);console.log(datastr);SEDAPI.call(datastr,this.apiSetRegistrarAlias.bind(this),params);}
apiSetRegistrarAlias(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){var registrar=params[0];var alias=params[1];var dt=this.options.panels.details.domaintable;if(typeof dt.registrar_aliases!='undefined'){dt.registrar_aliases[registrar.toLowerCase()]=alias;dt.reload();}}
else if(x.error!='')
$('#regalias-error').html(x.error);}}}
class SubdomainColumnSetup{constructor(options={}){if(!SubdomainColumnSetup._instance){this.init(options);SubdomainColumnSetup._instance=this;}
return SubdomainColumnSetup._instance;}
init(options){this.options=options;new UserInput().eventHandler('#panel-sdcolumnsetup',this);}
show(dgroup){this.tablename=dgroup+'table';new PopupPanel("panel-sdcolumnsetup");this.showStatus('');this.fillColumnNameRows(dgroup);}
showStatus(msg){PopupPanel.showStatus('sdcolumnsetup-error',msg);}
fillColumnNameRows(dgroup){this.column_group=dgroup;var datastr=SEDAPI.construct("list","subdomain","columns");if(dgroup=="dns")
datastr+="&grid=dns";else if(dgroup=="ssl")
datastr+="&grid=ssl";SEDAPI.call(datastr,this.apiGotSubdomainColumns.bind(this),dgroup);}
apiGotSubdomainColumns(x,jqXHR,textStatus,params){var list="";if(x!=null){if(x.status=='ok'){var datacolumns=DataTableView.getTable(this.tablename).options.columns;var exists=[];var index=1;var colnum=datacolumns.length;for(var i=0;i<colnum;i++){if(datacolumns[i].name!="rn"&&datacolumns[i].name!="cb"&&datacolumns[i].name!="domain"){var key=datacolumns[i].name;key=key.replaceAll("s.","");var label=datacolumns[i].label;exists.push(key);var fieldclass='';var pkey=key;if(!x.columns.hasOwnProperty(pkey))
pkey=pkey.replace('d.','');if(x.columns.hasOwnProperty(pkey)){var ftype=x.columns[pkey]['fieldtype'];fieldclass='column-type-'+ftype;fieldclass+=parseInt(x.columns[pkey]['custom'])?'-custom':'';}
if(key!=='r_h_disp'&&key!=='r_h_disp'&&key!="dt_ser_num"&&key!="domain"){list+="<li tabindex=\"0\" data-index=\""+index+"\" data-id=\""+key+"\"><div class=\"datatable-column-selector\"><div class=\""+fieldclass+"\"></div><div>"+label+"</div></div></li>\n";index++;}}}
for(var key in x.columns){if(key==='length'||!x.columns.hasOwnProperty(key)||key=="domain")continue;key=key.replaceAll("s.","");var custom=parseInt(x.columns[key]['custom']);if(custom)continue;if(exists.indexOf(key)>=0||exists.indexOf(key.replace("s.",""))>=0||exists.indexOf("s."+key)>=0)
continue;var label=x.columns[key]['label'];var ftype=x.columns[key]['fieldtype'];var gridview=parseInt(x.columns[key]['gridview']);var editable=parseInt(x.columns[key]['editable']);var fieldclass='column-type-'+ftype;if(gridview!=0&&key!="dt_ser_num"&&key!="d.domain"&&key!="r_h_disp"&&key!=='d.r_h_disp'&&exists.indexOf(key)<0){list+="<li tabindex=\"0\" data-index=\""+index+"\" data-id=\""+key+"\"><div class=\"datatable-column-selector\"><div class=\""+fieldclass+"\"></div><div>"+label+"</div></div></li>\n";index++;}}}}
var currentcolumns=exists;$('#subdomain-table-columns').html(list);var instance=this;var lb=new ItemList('subdomain-table-columns',{click:function(itemdata){instance.columnRowClicked(itemdata);},sortable:true,checkbox:true,onsort:function(itemid,ui){instance.rowsSorted(itemid,ui);},nosort:'nosort'});lb.setSelectionIds(currentcolumns);}
columnRowClicked(itemdata){}
rowsSorted(itemid,ui){}
updateSubdomainColumns(){var lb=ItemList.getItemList('subdomain-table-columns');var checkedIds=lb.getSelectionIds();var sdgroup=((this.column_group=='dns')?'subdomaingrid':'sslgrid')+'_columns_array';var datastr=SEDAPI.construct("set","subdomain","colmodel");datastr+="&group="+encodeURIComponent(sdgroup);var colsetup="";var length=checkedIds.length;var columns=new Array();for(var i=0;i<length;i++){columns[i]=checkedIds[i];colsetup+=columns[i];if(i!=(length-1))
colsetup+=";";}
this.showStatus("Please wait");datastr+="&columns="+encodeURIComponent(colsetup);SEDAPI.call(datastr,this.apiColumnSetupDone.bind(this),sdgroup);}
resetSubdomainColumns(){var sdgroup=((this.column_group=='dns')?'subdomaingrid':'sslgrid')+'_columns_array';var datastr=SEDAPI.construct("set","subdomain","colmodel");datastr+="&group="+encodeURIComponent(sdgroup);datastr+="&columns=";this.showStatus("Please wait");SEDAPI.call(datastr,this.apiColumnSetupDone.bind(this),sdgroup);}
apiColumnSetupDone(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){this.showStatus('OK');window[params]=x.colmodel;DataTableView.getTable(this.tablename).setColumns(x.colmodel);if(x.columns=='reset')
PopupPanel.hidePanel("panel-sdcolumnsetup");}
else
this.showStatus(x.error);}}}
class SubdomainAdder{constructor(options={}){if(!SubdomainAdder._instance){this.init(options);SubdomainAdder._instance=this;}
return SubdomainAdder._instance;}
init(options){this.options=options;new SelectBox('select_sdtype');new UserInput().eventHandler('#panel-addsubdomains',this);}
showStatus(msg){PopupPanel.showStatus('addsubdomains-error',msg);}
show(domainid,domain,defsel="sd"){this.domainid=domainid;this.domain=domain;console.log(domain+':'+domainid);new PopupPanel("panel-addsubdomains");$('#addsubdomains-domain').html(domain);this.domainid=domainid;var sb=SelectBox.getSelectBox('select_sdtype');if(sb)
sb.set(defsel);}
resetAddSubdomains(){$('#addsubdomains-data').val("");}
submitAddSubdomains(){this.showStatus('please wait');var subdomdata=$('#addsubdomains-data').val();var sdtype=SelectBox.getSelectBox('select_sdtype').get();var datastr=SEDAPI.construct("add","domain","subdomains");datastr+="&data="+encodeURIComponent(subdomdata)+"&domain="+encodeURIComponent(this.domain);datastr+="&type="+encodeURIComponent(sdtype);SEDAPI.call(datastr,this.apiSubdomainsAdded.bind(this),null);}
apiSubdomainsAdded(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){if(x.added>0){this.showStatus('ok');var dt=this.options.panels.details.domaintable;if(dt){var ids=dt.getSelectedIds();dt.reload();if(ids.includes(dt.last_highlighted_rowid))
this.options.panels.details.showDomain(dt.last_highlighted_rowid);}}
else{this.showStatus("Nothing added");}}}}}
class SubDomainEdit{constructor(options={}){if(!SubDomainEdit._instance){this.init(options);SubDomainEdit._instance=this;}
return SubDomainEdit._instance;}
init(options){this.options=options;new UserInput().eventHandler('#panel-editsubdomains',this);}
show(){new PopupPanel("panel-editsubdomains");}
showStatus(msg){PopupPanel.showStatus('editsubdomains-error',msg);}}
function findTextDiff(textBefore,textAfter){var differences=new TextDifferencer().findDifferencesBetweenStrings(textBefore,textAfter);var differencesAsString=differences.toString();differencesAsString=differencesAsString.replaceAll("\n","<br>");differencesAsString=differencesAsString.replaceAll('<span class="difference-highlight"></span>','');return differencesAsString;}
function ArrayExtensions(){}{Array.prototype.insertElementAt=function(element,index){this.splice(index,0,element);}
Array.prototype.insertElementsAt=function(elements,index){for(var i=0;i<elements.length;i++){this.splice(index+i,0,elements[i]);}}
Array.prototype.removeAt=function(index){this.splice(index,1);}}
function TextDifferencer(){}{TextDifferencer.prototype.findDifferencesBetweenStrings=function(string0,string1){var lengthOfShorterString=(string0.length<=string1.length?string0.length:string1.length);var numberOfExtremes=2;var passagePairsMatchingAtExtremes=[];for(var e=0;e<numberOfExtremes;e++){var lengthOfMatchingSubstring=0;for(var i=0;i<lengthOfShorterString;i++){var offsetForString0=(e==0?i:string0.length-i-1);var offsetForString1=(e==0?i:string1.length-i-1);var charFromString0=string0[offsetForString0];var charFromString1=string1[offsetForString1];if(charFromString0!=charFromString1){lengthOfMatchingSubstring=i;break;}}
var matchingSubstringAtExtreme;if(e==0){matchingSubstringAtExtreme=string0.substr(0,lengthOfMatchingSubstring);string0=string0.substr(lengthOfMatchingSubstring);string1=string1.substr(lengthOfMatchingSubstring);}else{matchingSubstringAtExtreme=string0.substr(string0.length-lengthOfMatchingSubstring);string0=string0.substr(0,string0.length-lengthOfMatchingSubstring);string1=string1.substr(0,string1.length-lengthOfMatchingSubstring);}
var passagePairMatchingAtExtreme=new TextPassagePair(true,[new TextPassage(matchingSubstringAtExtreme),new TextPassage(matchingSubstringAtExtreme),]);passagePairsMatchingAtExtremes.push(passagePairMatchingAtExtreme);}
var passagePairsAll=[];var passagePairsMatching=this.findPassagePairsMatchingBetweenStrings(string0,string1,[0,0]);this.insertPassagePairsDifferentBetweenMatching(string0,string1,passagePairsMatching,passagePairsAll);for(var e=0;e<passagePairsMatchingAtExtremes.length;e++){var passagePairMatchingAtExtreme=passagePairsMatchingAtExtremes[e];passagePairsAll.insertElementAt(passagePairMatchingAtExtreme,(e==0?0:passagePairsAll.length));}
var returnValue=new TextDifferences(passagePairsAll);return returnValue;}
TextDifferencer.prototype.findPassagePairsMatchingBetweenStrings=function(string0,string1,positionOffsets){var passagePairsMatching=[];var longestCommonPassagePair=this.findLongestCommonPassagePair(string0,string1);var longestCommonPassageText=longestCommonPassagePair.passages[0].text;var lengthOfCommonPassage=longestCommonPassageText.length;if(lengthOfCommonPassage==0){return passagePairsMatching;}
passagePairsMatching.push(longestCommonPassagePair);var passages=longestCommonPassagePair.passages;var passage0=passages[0];var passage1=passages[1];var passagePairsMatchingBeforeCommon=this.findPassagePairsMatchingBetweenStrings(string0.substr(0,passage0.position),string1.substr(0,passage1.position),[positionOffsets[0],positionOffsets[1]]);var passagePairsMatchingAfterCommon=this.findPassagePairsMatchingBetweenStrings(string0.substr(passage0.position+lengthOfCommonPassage),string1.substr(passage1.position+lengthOfCommonPassage),[positionOffsets[0]+passage0.position+lengthOfCommonPassage,positionOffsets[1]+passage1.position+lengthOfCommonPassage]);var passagePairSetsMatchingBeforeAndAfter=[passagePairsMatchingBeforeCommon,passagePairsMatchingAfterCommon];for(var i=0;i<passagePairSetsMatchingBeforeAndAfter.length;i++){var passagePairsToInsert=passagePairSetsMatchingBeforeAndAfter[i];passagePairsMatching.insertElementsAt(passagePairsToInsert,(i==0?0:passagePairsMatching.length));}
for(var i=0;i<longestCommonPassagePair.passages.length;i++){var passage=longestCommonPassagePair.passages[i];passage.position+=positionOffsets[i];}
return passagePairsMatching;}
TextDifferencer.prototype.findLongestCommonPassagePair=function(string0,string1){var passage0=new TextPassage("",0);var passage1=new TextPassage("",0);var returnValue=new TextPassagePair(true,[passage0,passage1]);var lengthOfString0=string0.length;var lengthOfString1=string1.length;var substringLengthsForRow=null;var substringLengthsForRowPrev;var lengthOfLongestCommonSubstringSoFar=0;var longestCommonSubstringsSoFar="";var cellIndex=0;for(var i=0;i<lengthOfString0;i++){substringLengthsForRowPrev=substringLengthsForRow;substringLengthsForRow=[];for(var j=0;j<lengthOfString1;j++){if(string0[i]!=string1[j]){substringLengthsForRow[j]=0;}
else{var cellValue;if(i==0||j==0){cellValue=1;}
else{cellValue=substringLengthsForRowPrev[j-1]+1;}
substringLengthsForRow[j]=cellValue;if(cellValue>lengthOfLongestCommonSubstringSoFar){lengthOfLongestCommonSubstringSoFar=cellValue;var startIndex=i-lengthOfLongestCommonSubstringSoFar+1;var longestCommonSubstringSoFar=string0.substring
(startIndex,i+1);passage0.text=longestCommonSubstringSoFar;passage0.position=startIndex;passage1.text=longestCommonSubstringSoFar;passage1.position=j-lengthOfLongestCommonSubstringSoFar+1;}}}}
return returnValue;}
TextDifferencer.prototype.insertPassagePairsDifferentBetweenMatching=function(string0,string1,passagePairsToInsertBetween,passagePairsAll){passagePairsToInsertBetween.insertElementAt(new TextPassagePair(true,[new TextPassage("",0),new TextPassage("",0)]),0);passagePairsToInsertBetween.push(new TextPassagePair(true,[new TextPassage("",string0.length),new TextPassage("",string1.length)]));var pMax=passagePairsToInsertBetween.length-1;for(var p=0;p<pMax;p++){passagePairToInsertAfter=passagePairsToInsertBetween[p];passagePairToInsertBefore=passagePairsToInsertBetween[p+1];this.buildAndInsertPassagePairBetweenExisting(string0,string1,passagePairToInsertBefore,passagePairToInsertAfter,passagePairsAll);passagePairsAll.push(passagePairToInsertBefore);}
var indexOfPassagePairFinal=passagePairsAll.length-1;var passagePairFinal=passagePairsAll[indexOfPassagePairFinal];if(passagePairFinal.doPassagesMatch==true&&passagePairFinal.passages[0].text.length==0){passagePairsAll.removeAt(indexOfPassagePairFinal,1);}}
TextDifferencer.prototype.buildAndInsertPassagePairBetweenExisting=function(string0,string1,passagePairToInsertBefore,passagePairToInsertAfter,passagePairsAll){var lengthOfPassageToInsertAfter=passagePairToInsertAfter.passages[0].text.length;var positionsForPassagePairDifferent=[[passagePairToInsertAfter.passages[0].position+lengthOfPassageToInsertAfter,passagePairToInsertAfter.passages[1].position+lengthOfPassageToInsertAfter],[passagePairToInsertBefore.passages[0].position,passagePairToInsertBefore.passages[1].position]];var passageToInsert0=new TextPassage(string0.substring
(positionsForPassagePairDifferent[0][0],positionsForPassagePairDifferent[1][0]),positionsForPassagePairDifferent[0][0]);var passageToInsert1=new TextPassage(string1.substring
(positionsForPassagePairDifferent[0][1],positionsForPassagePairDifferent[1][1]),positionsForPassagePairDifferent[0][1]);var passagePairToInsert=new TextPassagePair(false,[passageToInsert0,passageToInsert1]);if(passagePairToInsert.passages[0].text.length>0||passagePairToInsert.passages[1].text.length>0){passagePairsAll.push(passagePairToInsert);}}}
function TextDifferences(passagePairs){this.passagePairs=passagePairs;}{TextDifferences.prototype.toString=function(){var returnValue="";for(var p=0;p<this.passagePairs.length;p++){var passagePair=this.passagePairs[p];var passagePairAsString=passagePair.toString();returnValue+=passagePairAsString;}
return returnValue;}}
function TextPassage(text,position){this.text=text;this.position=position;}
function TextPassagePair(doPassagesMatch,passages){this.doPassagesMatch=doPassagesMatch;this.passages=passages;}{TextPassagePair.prototype.toString=function(){var returnValue="";if(this.doPassagesMatch==true){returnValue=this.passages[0].text;returnValue=this.escapeStringForHTML(returnValue);}
else{returnValue+="<span class=\"difference-highlight\">";returnValue+=this.escapeStringForHTML(this.passages[0].text);returnValue+="</span><span class=\"hidethis\">";returnValue+=this.escapeStringForHTML(this.passages[1].text);returnValue+="</span>";}
return returnValue;}
TextPassagePair.prototype.escapeStringForHTML=function(stringToEscape){var returnValue=stringToEscape.replace("&","&amp;").replace("<","&lt;").replace(">","&gt;").replace("\n","<br />");return returnValue;}}
class UserInterface{constructor(options={}){if(!UserInterface._instance){this.init();UserInterface._instance=this;}
else{var sb=SelectBox.getSelectBox('colormode');sb.set(ColorMode.getModeSetting());sb=SelectBox.getSelectBox('themename');sb.set(ColorMode.getThemeSetting());return UserInterface._instance;}}
init(){$('#colormode').val(ColorMode.getModeSetting());$('#themename').val(ColorMode.getThemeSetting());new SelectBox('colormode',{change:this.onColorModeChange.bind(this)});var ippSB=new SelectBox('data-items-per-page',{change:this.onIPPChange.bind(this)});let ipp=getCookieInt(COOKIE_ITEMS_PER_PAGE,250);ippSB.set(ipp);let ehighlight=getCookieInt(COOKIE_EXPIRY_HIGLIGHT_DAYS,30);if(ehighlight<30||ehighlight>90)
ehighlight=30;$("#expiry-highlight-days").val(ehighlight);$("#expiry-highlight-days").change(function(){let ehighlight=$("#expiry-highlight-days").val();if(ehighlight<30||ehighlight>90)
ehighlight=30;saveCookie(COOKIE_EXPIRY_HIGLIGHT_DAYS,ehighlight);});this.initTheme(ColorMode.getModeSetting());let transparency=getCookieInt(COOKIE_CONTENT_TRANSPARENCY,5);new RangeSlider('content-transparency-slider',{output:'content-transparency',min:0,max:15,value:transparency,handlers:{onchange:this.onTransparencyChange.bind(this)}});$('#content-transparency').html(transparency);let blurpixels=getCookieInt(COOKIE_CONTENT_BLURFILTER,5);new RangeSlider('content-blur-slider',{output:'content-blur-pixels',min:0,max:15,value:blurpixels,handlers:{onchange:this.onContentBlurChange.bind(this)}});$('#content-blur-pixels').html(blurpixels);this.enableBlurChange(transparency);}
initTheme(cmode){var mode=ColorMode.getRealMode(cmode);var datastr=SEDAPI.construct("list","ui","themes");datastr+="&mode="+encodeURIComponent(mode);SEDAPI.call(datastr,this.apiGotThemeList.bind(this),cmode);}
onIPPChange(value){var theme=SelectBox.getSelectBox('data-items-per-page').get();saveCookie(COOKIE_ITEMS_PER_PAGE,value);}
onColorModeChange(value){saveCookie(COOKIE_THEME_COLOR_MODE,value);this.initTheme(value);}
onThemeChange(value){saveCookie(COOKIE_THEME_THEME_NAME,value);var cmode=SelectBox.getSelectBox('colormode').get();new ColorMode().set(cmode,value);}
show(){new PopupPanel('panel-uisetup');}
apiGotThemeList(x,jqXHR,textStatus,cmode){if(x!=null){if(x.status=='ok'){var options='';for(var i=0;i<x.themes.length;i++){options+='<option value="'+x.themes[i]+'">'+x.themes[i]+'</option>';}
$('#themename').html(options);var theme=ColorMode.getThemeSetting();if(!theme||!x.themes.includes(theme))
theme='Default';$('#themename').val(theme);new SelectBox('themename',{change:this.onThemeChange.bind(this)});new ColorMode().set(cmode,theme);}}}
onTransparencyChange(evalue){saveCookie(COOKIE_CONTENT_TRANSPARENCY,evalue.value);ColorMode.setTransparency(evalue.value);this.enableBlurChange(evalue.value);}
enableBlurChange(transparency){let blurpixels=getCookieInt(COOKIE_CONTENT_BLURFILTER,5);if(transparency==0){$("#content-blur-slider-slider").prop('disabled',true);$('#content-blur-pixels').html('disabled');}
else{$("#content-blur-slider-slider").prop('disabled',false);$('#content-blur-pixels').html(blurpixels);}}
onContentBlurChange(evalue){saveCookie(COOKIE_CONTENT_BLURFILTER,evalue.value);ColorMode.setFilterBlur(evalue.value);}}