<?php
###############################################################################
# Admin.php
#
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
#
############################################################################### 

namespace 	CodePunch\UI\Modules;

use 		CodePunch\Base\Util as UTIL;
use			CodePunch\Base\Text as TEXT;
use 		Exception;

###############################################################################

class Admin  {

	###########################################################################
	
	public function get($auth) 
	{		
		$pagecontent = array();
		$folder = UTIL::get_install_folder_path();
		if($auth && $auth->isAdmin()) {
			$homefile = $folder . "lib/layouts/modules/dashboard/settings.htm";
			$datafile = $folder . "lib/layouts/modules/dashboard/admin.inc.htm";
			$pagecontent['home'] = file_get_contents($homefile);
			$pagecontent['body'] = file_get_contents($datafile);
			$pagecontent['heading'] = "<h1>" . TEXT::get("Application Settings") . "</h1>";
		}
		else {
			$homefile = $folder . "lib/layouts/modules/dashboard/verify.htm";
			$pagecontent['home'] = file_get_contents($homefile);
			$pagecontent['body'] = "<p class=\"problem\">Access Denied</p>";
			$pagecontent['heading'] = "<h1>" . TEXT::get("Problem") . "</h1>";
		}
		return $pagecontent;
	}
	
	###########################################################################
}
