<?php
###############################################################################
# DummyIDP.php
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
#
# Sample Identity provider. Use this as a template for coding other IDPs
#
############################################################################### 

namespace 	CodePunch\Config\SAML;

use 		CodePunch\Base\Util as UTIL;
use 		CodePunch\Base\Text as TEXT;
use 		CodePunch\DB\Audit as AUDIT;
use 		Exception;

###############################################################################

class DummyIDP Extends SAMLBase {
	
	# property / local variable declarations
	
	###########################################################################
	
	public function __construct($auth, $doload=true)
	{ 
		parent::__construct($auth);
		if($doload)
			$this->load();
	}
	
	###########################################################################
	
	private function load()
	{
		# Initialize
		# For example get the metadata from the IDP
		# See Okta.php for an example
	}
	
	###########################################################################
	
	public function login()
	{
		# Perform the login by redirecting to IDP
	}
	
	###########################################################################
	# Local Logout
	
	public function logout()
	{
		# Do logout
	}
	
	###########################################################################
	
	public function ACS()
	{
	}
	
	###########################################################################
	
	public function SLS()
	{
		# Logout from IDP
	}
	
	###########################################################################
	
	public function hasSettings()
	{
		# return true if this IDP has been properly setup, else return false;
	}
	
	###########################################################################
	
	public function process()
	{
		# process the data from IDP.
		# Once you have a valid idp username ($idpuser), do
		/*
		$samldata = array('idp'=>'IDP Name', 'user'=>$idpuser);
		$localuser = $this->get_valid_user_name($idpuser);
		$this->processUser($localuser, $samldata);
		*/
	}
	
	###########################################################################
	
	public function getOptions()
	{
		# return an array containing the configuration options for this IDP
		/*
		return array (
			'client_id' => array('string', 'ID Provider', 'Client ID'),
			'client_secret' => array('string', 'ID Provider', 'Client Secret'),
			'dummyidp_domain' => array('string', 'ID Provider', 'DummyIDP Domain')
		);
		*/
	}
	
	###########################################################################
	
	public function getSettings()
	{
		/* Read the configuration settings from the DB and return as an array */
		$setup = new \CodePunch\Config\Settings($this->getAuth());
		$settingsInfo = array();
		/*
		$settingsInfo['client_id'] = $setup->getEncryptedOption("dummyidp_client_id", "");
		$settingsInfo['client_secret'] = $setup->getEncryptedOption("dummyidp_client_secret", "");
		$settingsInfo['dummyidp_domain'] = $setup->getEncryptedOption("dummyidp_dummyidp_domain", "");
		*/
		return $settingsInfo;
	}
	
}

###############################################################################
