class UserInterface{constructor(options={}){if(!UserInterface._instance){this.init();UserInterface._instance=this;}
else{var sb=SelectBox.getSelectBox('colormode');sb.set(ColorMode.getModeSetting());sb=SelectBox.getSelectBox('themename');sb.set(ColorMode.getThemeSetting());return UserInterface._instance;}}
init(){$('#colormode').val(ColorMode.getModeSetting());$('#themename').val(ColorMode.getThemeSetting());new SelectBox('colormode',{change:this.onColorModeChange.bind(this)});var ippSB=new SelectBox('data-items-per-page',{change:this.onIPPChange.bind(this)});let ipp=getCookieInt(COOKIE_ITEMS_PER_PAGE,250);ippSB.set(ipp);this.initTheme(ColorMode.getModeSetting());let transparency=getCookieInt(COOKIE_CONTENT_TRANSPARENCY,5);new RangeSlider('content-transparency-slider',{output:'content-transparency',min:0,max:15,value:transparency,handlers:{onchange:this.onTransparencyChange.bind(this)}});$('#content-transparency').html(transparency);let blurpixels=getCookieInt(COOKIE_CONTENT_BLURFILTER,5);new RangeSlider('content-blur-slider',{output:'content-blur-pixels',min:0,max:15,value:blurpixels,handlers:{onchange:this.onContentBlurChange.bind(this)}});$('#content-blur-pixels').html(blurpixels);this.enableBlurChange(transparency);}
initTheme(cmode){var mode=ColorMode.getRealMode(cmode);var datastr=SEDAPI.construct("list","ui","themes");datastr+="&mode="+encodeURIComponent(mode);SEDAPI.call(datastr,this.apiGotThemeList.bind(this),cmode);}
onIPPChange(value){var theme=SelectBox.getSelectBox('data-items-per-page').get();saveCookie(COOKIE_ITEMS_PER_PAGE,value);}
onColorModeChange(value){saveCookie(COOKIE_THEME_COLOR_MODE,value);this.initTheme(value);}
onThemeChange(value){saveCookie(COOKIE_THEME_THEME_NAME,value);var cmode=SelectBox.getSelectBox('colormode').get();new ColorMode().set(cmode,value);}
show(){new PopupPanel('panel-uisetup');}
apiGotThemeList(x,jqXHR,textStatus,cmode){if(x!=null){if(x.status=='ok'){var options='';for(var i=0;i<x.themes.length;i++){options+='<option value="'+x.themes[i]+'">'+x.themes[i]+'</option>';}
$('#themename').html(options);var theme=ColorMode.getThemeSetting();if(!theme||!x.themes.includes(theme))
theme='Default';$('#themename').val(theme);new SelectBox('themename',{change:this.onThemeChange.bind(this)});new ColorMode().set(cmode,theme);}}}
onTransparencyChange(evalue){saveCookie(COOKIE_CONTENT_TRANSPARENCY,evalue.value);ColorMode.setTransparency(evalue.value);this.enableBlurChange(evalue.value);}
enableBlurChange(transparency){let blurpixels=getCookieInt(COOKIE_CONTENT_BLURFILTER,5);if(transparency==0){$("#content-blur-slider-slider").prop('disabled',true);$('#content-blur-pixels').html('disabled');}
else{$("#content-blur-slider-slider").prop('disabled',false);$('#content-blur-pixels').html(blurpixels);}}
onContentBlurChange(evalue){saveCookie(COOKIE_CONTENT_BLURFILTER,evalue.value);ColorMode.setFilterBlur(evalue.value);}}
class BulkEdit{constructor(options={}){if(!BulkEdit._instance){this.init(options);BulkEdit._instance=this;}
return BulkEdit._instance;}
init(options){this.options=options;new UserInput().eventHandler('#panel-bulkedit',this);}
getSubdomains(sourcetable,domain){var subdomains=[];var dt=DataTableView.getTable(sourcetable);if(dt){this.hids=[parseInt(dt.last_highlighted_rowid)];console.log(this.hids);console.log(dt.options.data);for(var i=0;i<dt.options.data.length;i++){var hid=parseInt(dt.options.data[i].id);if(this.hids.includes(hid))
subdomains.push(dt.options.data[i]['s.subdomain']+'.'+domain);}}
return subdomains;}
show(source="domain",columns,selected){var i18n=new Translator();this.source=source;this.options.selected=undefined;if(columns!==undefined&&columns.length){this.options.validcolumns=columns;if(selected===undefined)
selected=columns[0];}
else
this.options.validcolumns=undefined;if(selected!==undefined&&this.options.validcolumns!==undefined&&this.options.validcolumns.includes(selected))
this.options.selected=selected;var dt=this.options.panels.details.domaintable;var sc=dt.getSelectedDomainCount();if(sc){if(this.source=="dns"||this.source=="ssl"){var domainid=getCookieInt(COOKIE_SELECTED_DOMAIN_ID,0);this.ids=[domainid];var domain=this.options.panels.details.current_selected_domain;var subdomains=this.getSubdomains(this.source+'table',domain);var affected=subdomains.join(', ');}
else if(this.source=="sslcerts"){}
else{this.ids=dt.getSelectedIds();var affected=dt.getAffectedDomainsText();}
$('.affected-domains').html(affected);new PopupPanel("panel-bulkedit");this.showStatus('');this.fillColumnNameRows();}
else
PopupPanel.showPopup(i18n.__("Please select the domains to edit by checking the boxes for the corresponding entries in the data table."),i18n.__("No Domains Selected"));if(this.source=="domain")
$('.event-resetEditFlag').show();else
$('.event-resetEditFlag').hide();}
showStatus(msg){PopupPanel.showStatus('bulkedit-error',msg);}
reSize(){var th02=0;if($(window).width()>=630){$("#bulkedit-pane02 > div").each(function(){th02+=$(this).outerHeight(true);});$('#bulkedit-columns').css('height',th02);}
else
$('#bulkedit-columns').css('height',150);}
columnRowClicked(itemdata){var column=itemdata.item;$('#bulkedit-column').html(column);this.data_column=column;var label=this.domain_column_labels[column];$('#bulkedit-column-label').html('Label: '+label);$('#bulkedit-value').val('');if(this.source=="domain"){var dt=this.options.panels.details.domaintable;var sc=dt.getSelectedDomainCount();var theid=this.ids[0];}
else{var dt=DataTableView.getTable(this.source+'table');var sc=1;var theid=this.hids[0];}
if(sc==1){var tabledata=dt.options.data;for(var row=0;row<tabledata.length;row++){var rowid=tabledata[row][dt.options.idcolumn];if(parseInt(rowid)==theid){var value=tabledata[row][column];if(value===undefined&&this.source=='domain')
value=tabledata[row]['d.'+column];if(value===undefined&&this.source!='domain')
value=tabledata[row]['s.'+column];if(value!==undefined){$('#bulkedit-value').val(value);}}}}}
resetEditFlag(){var ids=this.ids;var datastr=SEDAPI.construct("set","domain","edit");datastr+="&id="+encodeURIComponent(ids.join(","));datastr+="&columns="+encodeURIComponent("manual_edited_at");datastr+="&data="+encodeURIComponent("null");SEDAPI.call(datastr,this.apiBulkEditDone.bind(this),null);}
submitBulkEdit(){this.showStatus('please wait');var field=this.data_column;var value=$('#bulkedit-value').val();if(this.source=="domain"){var ids=this.ids;var datastr=SEDAPI.construct("set","domain","edit");datastr+="&id="+encodeURIComponent(ids.join(","));datastr+="&columns="+encodeURIComponent(field);datastr+="&data="+encodeURIComponent(value);SEDAPI.call(datastr,this.apiBulkEditDone.bind(this),null);}
else{var ids=this.hids;var datastr=SEDAPI.construct("grid",this.source,"edit");datastr+="&id="+encodeURIComponent(this.hids[0]);datastr+="&"+field+"="+encodeURIComponent(value);SEDAPI.call(datastr,this.apiSubdomainEditDone.bind(this),null);}}
apiBulkEditDone(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){if(x.updated>0){var dt=this.options.panels.details.domaintable;dt.reload();if(this.ids.includes(dt.last_highlighted_rowid))
this.options.panels.details.showDomain(dt.last_highlighted_rowid);}
this.showStatus('ok');}
else{this.showStatus(x.error);}}}
apiSubdomainEditDone(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){var dt=DataTableView.getTable(this.source+'table');if(dt)
dt.reload();this.showStatus('ok');}
else{this.showStatus(x.error);}}}
fillColumnNameRows(){var source=this.source;if(this.source=="dns"|this.source=="ssl")
source="subdomain";var datastr=SEDAPI.construct("list",source,"columns");if(this.source=='dns')
datastr+="&grid=dns";else if(this.source=='ssl')
datastr+="&grid=ssl";SEDAPI.call(datastr,this.apiColumnDataReceived.bind(this),null);}
apiColumnDataReceived(x,jqXHR,textStatus,params){if(x!=null){if(x.status=='ok'){var list=this.getColumnList(x.columns,this.options.validcolumns);$('#bulkedit-columns').html(list);new ItemList('bulkedit-columns',{click:this.columnRowClicked.bind(this)});if(this.options.selected===undefined)
this.options.selected=$("#bulkedit-columns li:nth-child(1)").attr('id');$('#'+this.options.selected).addClass('active');this.columnRowClicked({list:'bulkedit-columns',item:this.options.selected});this.reSize();}}}
getColumnList(columns,validcolumns){this.default_domain_columns=[];this.custom_domain_columns=[];this.domain_column_labels=[];this.domain_data_columns=columns;if(validcolumns!==undefined&&validcolumns.length){for(var i=0;i<validcolumns.length;i++){var key=validcolumns[i];if(columns.hasOwnProperty(key)){var label=columns[key]['label'];var gridview=parseInt(columns[key]['gridview']);var editable=parseInt(columns[key]['editable']);var custom=parseInt(columns[key]['custom']);if(!custom&&gridview&&editable){if(key!='r_h_disp')
this.default_domain_columns.push(key);}
else if(custom)
this.custom_domain_columns.push(key);this.domain_column_labels[key]=decodeURIComponent(label);}}}
else{for(var key in columns){if(key==='length'||!columns.hasOwnProperty(key)||key==='domain')continue;var label=columns[key]['label'];var ftype=columns[key]['fieldtype'];var gridview=parseInt(columns[key]['gridview']);var editable=parseInt(columns[key]['editable']);var custom=parseInt(columns[key]['custom']);if(!custom&&gridview&&editable){if(key!='r_h_disp')
this.default_domain_columns.push(key);}
else if(custom)
this.custom_domain_columns.push(key);this.domain_column_labels[key]=decodeURIComponent(label);}}
return this.constructList(columns);}
constructList(columns){var list='';for(var i=0;i<this.custom_domain_columns.length;i++){var key=this.custom_domain_columns[i];var fieldclass='column-type-'+columns[key]['fieldtype']+"-custom";list+='<li id="'+key+'">'+"<div class=\"datatable-column-selector\"><div class=\""+fieldclass+"\"></div><div>"+key+"</div></div></li>";}
for(var i=0;i<this.default_domain_columns.length;i++){var key=this.default_domain_columns[i];var fieldclass='column-type-'+columns[key]['fieldtype'];list+='<li id="'+key+'">'+"<div class=\"datatable-column-selector\"><div class=\""+fieldclass+"\"></div><div>"+key+"</div></div></li>";}
return list;}}