<?php
###############################################################################
# GoogleIndex.php
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
#
############################################################################### 

namespace 	CodePunch\LU;
use 		CodePunch\Base\Util as UTIL;
use			CodePunch\Base\Text as TEXT;

###############################################################################

class GoogleIndex  {
	
	private $lookupManager = null;
	
	###########################################################################
	
	public function __construct($lum=null) {
		$this->lookupManager = $lum;
	}
	
	###############################################################################
	
	public function Lookup(&$ludata)
	{
		$db = $this->lookupManager->getAuthentication()->getDatabase();
		$did = $ludata['sid'];
		$domain = $db->getDomainName($did);
		$lookupcount = 0;
		if($did !== false && $did > 0) {
			$subdomain = "";
			$pagedata = $this->indexCount($domain, $subdomain);
			if($pagedata !== false) {
				$status = $this->lookupManager->updateDomainTable(\CodePunch\LU\LookupManager::GOOGLE_INDEX, $pagedata);
				if($status !== false) 
					$lookupcount++;
				$ludata['status'] = \CodePunch\LU\LookupManager::LUQ_COMPLETE;
			}
		}
		return $lookupcount;
	}
	
	###############################################################################

	public function search($domain)
	{	
		// Added April 28 2023
		// Don't do Google Index Searches any more because they almost always fail.
		return false;
		
		$this->lookupManager->setLastConnectForServer("google.com", 15);

		$url = "https://www.google.com/search?hl=en&q=site%3A$domain";
		$uagent = 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36.';
		$pagedata = UTIL::curl_get_url($url, 10, false, false, $uagent);
		if($pagedata['status'] == 200) 
			$data = $pagedata['result'];
		else
			return false;
		
		$db = $this->lookupManager->getAuthentication()->getDatabase();
		$sinfo = $db->getWhoisServerInfo("google.com");
		$bannedtext = $sinfo['bannedtext'];
		if(strlen($data) > 0 && strlen($bannedtext) > 0) {
			if(stristr($data, $bannedtext) !== false) {
				$this->lookupManager->lockServer("google");
				return false;
			}
		}
		
		$entry = UTIL::get_string_between($data, "id=\"result-stats\">", "</div>");
		$entry = strip_tags($entry);
		$pieces = explode(" ", $entry);
		$numarray = array();
		foreach($pieces as $p) {
			$p = str_replace(",", "", $p);
			if(is_numeric($p))
				$numarray[] = intval($p);
		}
		if(count($numarray)) {
			sort($numarray, SORT_NUMERIC);
			return $numarray[count($numarray)-1];
		}
		return 0;
	}

	###############################################################################

	public function indexCount($domain, $subdomain="www")
	{
		if(!$this->lookupManager->isConnectionsAllowedToServer("google.com"))
			return false;
			
		$host = UTIL::idn_convert_to_host_name($domain, $subdomain);
		$gicount = $this->search($domain);
		
		$data_array = array();
		$data_array['google_index_count'] = 0;
		if($gicount !== false)
			$data_array['google_index_count'] = $gicount;
		$data_array['domain'] = $domain;
		$data_array['google_index_checked_at'] = date("Y-m-d H:i:s");
		return $data_array;
	}

	
	###############################################################################

}

###############################################################################
