<?php
###############################################################################
# Logger.php
#
#
# @author Anil Kumar <akumar@codepunch.com>
# @link   https://codepunch.com
#
###############################################################################

namespace 	CodePunch\Base;

use 		CodePunch\Base\Util as UTIL;

###############################################################################

class RecentlyLoggedErrors {
	
	private static $errors = array();
	private static $maxcount  = 10;
	
	static public function add($message) {
		if(count(self::$errors) > self::$maxcount)
			array_shift(self::$errors);
		self::$errors[] = $message;
	}
	
	static public function getMaxCount() {
		return self::$maxcount;
	}
	
	static public function getCount() {
		return count(self::$errors);
	}
	
	static public function getAll() {
		return self::$errors;
	}
	
	static public function get($index) {
		if($index >= 0 && $index < self::getCount())
			return self::$errors[$index];
		return false;
	}
	
	static public function getLast() {
		return self::get(self::getCount()-1);
	}
	
	static public function clear() {
		self::$errors = array();
	}
	
	static public function setMaxCount($c) {
		self::$maxcount = $c;
	}
}

###############################################################################

class CPLogger extends \Katzgrau\KLogger\Logger
{
	private	$errors	= array();
	
	###########################################################################
	
    public function __construct($logDirectory="", $logLevelThreshold = \Psr\Log\LogLevel::DEBUG, array $options = array())
    {
		if($logDirectory == "")
			$logDirectory = UTIL::get_log_folder_path();
		if(!is_writable($logDirectory)) 
			$logDirectory = sys_get_temp_dir();
		// Use different prefixes for CLI and Web
		if(UTIL::is_cli() && !isset($options['prefix']))
			$options = array_merge($options, array('prefix' => 'clilog_'));
		else if(!isset($options['prefix']))
			$options = array_merge($options, array('prefix' => 'weblog_'));
		parent::__construct($logDirectory, $logLevelThreshold, $options);
	}
	
	###########################################################################
	
    public function log($level, $message, array $context = array())
    {
        if ($this->logLevels[$this->logLevelThreshold] < $this->logLevels[$level]) {
            return;
        }
		if($level == \Psr\Log\LogLevel::ERROR) {
			\CodePunch\Base\RecentlyLoggedErrors::add($message);
		}
		// Remove excess spaces and line feeds
		$message =  preg_replace('/\v(?:[\v\h]+)/', '', $message);
        $message = $this->formatMessage($level, $message, $context);
        $this->write($message);
		if($level == \Psr\Log\LogLevel::EMERGENCY) {
			UTIL::print($message);
			die();
		}
    }
	
	###########################################################################
	
	public function get($index)
	{
		return \CodePunch\Base\RecentlyLoggedErrors::get($index);
	}
	
	###########################################################################
	
	public function getAll()
	{
		return \CodePunch\Base\RecentlyLoggedErrors::getAll();
	}
	
	###########################################################################
	
	public function getLast()
	{
		return \CodePunch\Base\RecentlyLoggedErrors::getLast();
	}
	
	###########################################################################
	
	public function clearAll()
	{
		return \CodePunch\Base\RecentlyLoggedErrors::clear();
	}
}
