class SSLAdd {
	constructor(options={}) {
		if(!SSLAdd._instance) {
			this.init(options);
			SSLAdd._instance = this;
		}
		return SSLAdd._instance;
	}
	
	init(options) {
		this.options = options;
		new UserInput().eventHandler('#panel-ssladd', this);
	}
	
	show() {
		var i18n = new Translator();
		
		new PopupPanel("panel-ssladd");
		this.showStatus('');
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////
	
	showStatus(msg) {
		PopupPanel.showStatus('ssladd-error', msg);
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////
	
	reSize() {
	}
	
	submitSSLAdd() {
		this.showStatus('please wait');
		var pemdata = $('#ssladd-pemdata').val();
		var datastr = SEDAPI.construct("grid", "sslcerts", "add");
		datastr += "&pem=" + encodeURIComponent(pemdata);
		SEDAPI.call(datastr, this.apiSSLAddDone.bind(this), null);
	}
	
	apiSSLAddDone(x, jqXHR, textStatus, params) {
		if(x != null) {
			if(x.status == 'ok') {
				this.showStatus('ok');
				var ssltable = DataTableView.getTable('ssldatatable');
				if(ssltable != undefined) {
					ssltable.reload();
				}
			}
			else {
				this.showStatus(x.error);
			}
		}
	}
}
	